/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.repository.filesystem.plugin;

import java.nio.file.Path;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.puzzle.codec.xd.model.XdCrossword;
import re.belv.croiseur.puzzle.codec.xd.reader.XdCrosswordReader;
import re.belv.croiseur.puzzle.codec.xd.reader.XdReadException;
import re.belv.croiseur.puzzle.repository.filesystem.plugin.PuzzleConversionException;
import re.belv.croiseur.puzzle.repository.filesystem.plugin.PuzzleConverter;

final class PuzzleReader {
    private static final Logger LOGGER = Logger.getLogger(PuzzleReader.class.getName());
    private final XdCrosswordReader reader = new XdCrosswordReader();

    PuzzleReader() {
    }

    Optional<SavedPuzzle> read(Path path) {
        try {
            XdCrossword persistedCrosswordModel = this.reader.read(path);
            int id = PuzzleReader.idFrom(path);
            SavedPuzzle domainCrosswordModel = PuzzleConverter.toDomain(id, persistedCrosswordModel);
            return Optional.of(domainCrosswordModel);
        }
        catch (XdReadException | PuzzleConversionException e) {
            LOGGER.warning(() -> PuzzleReader.lambda$read$0(path, (Exception)e));
            LOGGER.log(Level.FINE, "", e);
            return Optional.empty();
        }
    }

    private static int idFrom(Path path) {
        String fileName = path.getFileName().toString();
        return Integer.parseInt(fileName.substring(0, fileName.lastIndexOf(46)));
    }

    private static /* synthetic */ String lambda$read$0(Path path, Exception e) {
        return "Failed to read " + String.valueOf(path) + ": " + e.getMessage();
    }
}

