/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class XdGrid {
    private final Set<Index> blocks;
    private final Set<Index> spaces;
    private final Set<Index> nonFilled;
    private final Map<Index, String> filled;

    private XdGrid(Builder builder) {
        this.blocks = new HashSet<Index>(builder.blocks);
        this.spaces = new HashSet<Index>(builder.spaces);
        this.nonFilled = new HashSet<Index>(builder.nonFilled);
        this.filled = new HashMap<Index, String>(builder.filled);
    }

    public Set<Index> blocks() {
        return Collections.unmodifiableSet(this.blocks);
    }

    public Set<Index> spaces() {
        return Collections.unmodifiableSet(this.spaces);
    }

    public Set<Index> nonFilled() {
        return Collections.unmodifiableSet(this.nonFilled);
    }

    public Map<Index, String> filled() {
        return Collections.unmodifiableMap(this.filled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XdGrid)) {
            return false;
        }
        XdGrid xdGrid = (XdGrid)o;
        return Objects.equals(this.blocks, xdGrid.blocks) && Objects.equals(this.spaces, xdGrid.spaces) && Objects.equals(this.nonFilled, xdGrid.nonFilled) && Objects.equals(this.filled, xdGrid.filled);
    }

    public int hashCode() {
        return Objects.hash(this.blocks, this.spaces, this.nonFilled, this.filled);
    }

    public String toString() {
        return "XdGrid{blocks=" + String.valueOf(this.blocks) + ", spaces=" + String.valueOf(this.spaces) + ", nonFilled=" + String.valueOf(this.nonFilled) + ", filled=" + String.valueOf(this.filled) + "}";
    }

    public static final class Builder {
        private final Set<Index> blocks = new HashSet<Index>();
        private final Set<Index> spaces = new HashSet<Index>();
        private final Set<Index> nonFilled = new HashSet<Index>();
        private final Map<Index, String> filled = new HashMap<Index, String>();

        public Builder block(Index index) {
            this.blocks.add(index);
            return this;
        }

        public Builder nonFilled(Index index) {
            this.nonFilled.add(index);
            return this;
        }

        public Builder space(Index index) {
            this.spaces.add(index);
            return this;
        }

        public Builder filled(Index index, char character) {
            this.filled.put(index, String.valueOf(character));
            return this;
        }

        public XdGrid build() {
            return new XdGrid(this);
        }

        public void reset() {
            this.blocks.clear();
            this.spaces.clear();
            this.nonFilled.clear();
            this.filled.clear();
        }
    }

    public record Index(int column, int row) {
        public static Index at(int column, int row) {
            return new Index(column, row);
        }
    }
}

