/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.reader;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import re.belv.croiseur.puzzle.codec.xd.model.XdClues;
import re.belv.croiseur.puzzle.codec.xd.reader.XdClueReadException;

final class XdCluesReader {
    private static final Pattern CLUE_REGEX = Pattern.compile("(?<orientation>[AD])(?<number>\\d+)\\. (?<clue>.*) ~ (?<answer>.+)");
    private final XdClues.Builder builder = new XdClues.Builder();

    XdCluesReader() {
    }

    XdClues read(String rawClues) throws XdClueReadException {
        Objects.requireNonNull(rawClues);
        this.builder.reset();
        String[] clues = rawClues.split("\\R");
        boolean parsingAcrossClues = true;
        for (String clue : clues) {
            if (parsingAcrossClues && clue.isEmpty()) {
                parsingAcrossClues = false;
                continue;
            }
            Matcher m = CLUE_REGEX.matcher(clue);
            if (!m.matches()) {
                throw new XdClueReadException("Invalid clue: '" + clue + "'. Expected format is: " + CLUE_REGEX.pattern() + "'.");
            }
            boolean isAcross = m.group("orientation").equals("A");
            if (parsingAcrossClues && !isAcross) {
                throw new XdClueReadException("Invalid clue: '" + clue + "'. Expected across clue but was down clue.");
            }
            if (!parsingAcrossClues && isAcross) {
                throw new XdClueReadException("Invalid clue: '" + clue + "'. Expected down clue but was across clue.");
            }
            int number = Integer.parseInt(m.group("number"));
            String actualClue = m.group("clue");
            String answer = m.group("answer");
            if (isAcross) {
                this.builder.across(number, actualClue, answer);
                continue;
            }
            this.builder.down(number, actualClue, answer);
        }
        return this.builder.build();
    }
}

