/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.reader;

import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import re.belv.croiseur.puzzle.codec.xd.model.XdMetadata;
import re.belv.croiseur.puzzle.codec.xd.reader.XdMetadataReadException;
import re.belv.croiseur.puzzle.codec.xd.reader.XdReadException;

final class XdMetadataReader {
    private static final String LINE_SEPARATOR = "\\R";
    private static final String PROPERTY_SEPARATOR = ":";
    private final XdMetadata.Builder builder = new XdMetadata.Builder();

    XdMetadataReader() {
    }

    XdMetadata read(String rawMetadata) throws XdReadException {
        Objects.requireNonNull(rawMetadata);
        this.builder.reset();
        block14: for (String line : rawMetadata.split(LINE_SEPARATOR)) {
            String[] keyValue = XdMetadataReader.splitKeyValues(line);
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            switch (key) {
                case "Title": {
                    this.builder.title(value);
                    continue block14;
                }
                case "Author": {
                    this.builder.author(value);
                    continue block14;
                }
                case "Editor": {
                    this.builder.editor(value);
                    continue block14;
                }
                case "Copyright": {
                    this.builder.copyright(value);
                    continue block14;
                }
                case "Date": {
                    this.builder.date(XdMetadataReader.parseDate(value));
                    continue block14;
                }
                default: {
                    this.builder.otherProperty(key, value);
                }
            }
        }
        return this.builder.build();
    }

    private static String[] splitKeyValues(String line) throws XdMetadataReadException {
        if (line.isEmpty()) {
            throw new XdMetadataReadException("Blank line");
        }
        String[] keyValue = line.split(PROPERTY_SEPARATOR);
        if (keyValue.length != 2) {
            throw new XdMetadataReadException("Invalid property '" + line + "'. Property must respect the format 'Key: Value'.");
        }
        return keyValue;
    }

    private static LocalDate parseDate(String date) throws XdMetadataReadException {
        try {
            return LocalDate.parse(date);
        }
        catch (DateTimeParseException e) {
            throw new XdMetadataReadException(e);
        }
    }

    private static final class StandardKeys {
        private static final String TITLE = "Title";
        private static final String AUTHOR = "Author";
        private static final String EDITOR = "Editor";
        private static final String COPYRIGHT = "Copyright";
        private static final String DATE = "Date";

        private StandardKeys() {
        }
    }
}

