/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.writer;

import java.util.Comparator;
import java.util.Objects;
import java.util.TreeMap;
import re.belv.croiseur.puzzle.codec.xd.model.XdGrid;

final class XdGridWriter {
    private static final Comparator<XdGrid.Index> SORTED_BY_ROW_THEN_BY_COLUMN = Comparator.comparingInt(XdGrid.Index::row).thenComparing(XdGrid.Index::column);

    XdGridWriter() {
    }

    String write(XdGrid grid) {
        Objects.requireNonNull(grid);
        TreeMap<XdGrid.Index, String> boxes = new TreeMap<XdGrid.Index, String>(SORTED_BY_ROW_THEN_BY_COLUMN);
        boxes.putAll(grid.filled());
        grid.nonFilled().forEach(index -> boxes.put((XdGrid.Index)index, "."));
        grid.blocks().forEach(index -> boxes.put((XdGrid.Index)index, "#"));
        grid.spaces().forEach(index -> boxes.put((XdGrid.Index)index, "_"));
        int lastColumn = ((XdGrid.Index)boxes.lastKey()).column();
        StringBuilder sb = new StringBuilder();
        boxes.forEach((index, content) -> {
            sb.append((String)content);
            if (index.column() == lastColumn) {
                sb.append('\n');
            }
        });
        return sb.toString();
    }
}

