/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui;

import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import re.belv.croiseur.api.CrosswordService;
import re.belv.croiseur.spi.clue.ClueProvider;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;
import re.belv.croiseur.spi.presenter.Presenter;
import re.belv.croiseur.spi.puzzle.codec.PuzzleDecoder;
import re.belv.croiseur.spi.puzzle.codec.PuzzleEncoder;
import re.belv.croiseur.spi.puzzle.repository.DummyPuzzleRepository;
import re.belv.croiseur.spi.puzzle.repository.PuzzleRepository;
import re.belv.croiseur.spi.solver.CrosswordSolver;

final class CrosswordServiceLoader {
    private CrosswordServiceLoader() {
    }

    static CrosswordService load(Presenter presenter) {
        Collection<DictionaryProvider> dictionaryProviders = CrosswordServiceLoader.load(DictionaryProvider.class);
        Collection<CrosswordSolver> solvers = CrosswordServiceLoader.load(CrosswordSolver.class);
        Collection<ClueProvider> clueProviders = CrosswordServiceLoader.load(ClueProvider.class);
        Collection<PuzzleDecoder> puzzleDecoders = CrosswordServiceLoader.load(PuzzleDecoder.class);
        Collection<PuzzleEncoder> puzzleEncoders = CrosswordServiceLoader.load(PuzzleEncoder.class);
        PuzzleRepository puzzleRepository = CrosswordServiceLoader.load(PuzzleRepository.class).stream().findFirst().orElseGet(DummyPuzzleRepository::new);
        return CrosswordService.create(dictionaryProviders, solvers, clueProviders, puzzleDecoders, puzzleEncoders, (PuzzleRepository)puzzleRepository, (Presenter)presenter);
    }

    private static <T> Collection<T> load(Class<T> clazz) {
        return ServiceLoader.load(clazz).stream().map(Supplier::get).toList();
    }
}

