/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import re.belv.croiseur.puzzle.codec.xd.model.XdClue;

public final class XdClues {
    private final List<XdClue> acrossClues;
    private final List<XdClue> downClues;

    private XdClues(List<XdClue> acrossCluesArg, List<XdClue> downCluesArg) {
        this.acrossClues = new ArrayList<XdClue>(acrossCluesArg);
        this.downClues = new ArrayList<XdClue>(downCluesArg);
    }

    public List<XdClue> acrossClues() {
        return Collections.unmodifiableList(this.acrossClues);
    }

    public List<XdClue> downClues() {
        return Collections.unmodifiableList(this.downClues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XdClues)) {
            return false;
        }
        XdClues xdClues = (XdClues)o;
        return Objects.equals(this.acrossClues, xdClues.acrossClues) && Objects.equals(this.downClues, xdClues.downClues);
    }

    public int hashCode() {
        return Objects.hash(this.acrossClues, this.downClues);
    }

    public String toString() {
        return "XdClues{acrossClues=" + String.valueOf(this.acrossClues) + ", downClues=" + String.valueOf(this.downClues) + "}";
    }

    public static final class Builder {
        private final List<XdClue> acrossClues = new ArrayList<XdClue>();
        private final List<XdClue> downClues = new ArrayList<XdClue>();

        public Builder across(int number, String clue, String answer) {
            XdClue xdClue = new XdClue(number, clue, answer);
            this.acrossClues.add(xdClue);
            return this;
        }

        public Builder down(int number, String clue, String answer) {
            XdClue xdClue = new XdClue(number, clue, answer);
            this.downClues.add(xdClue);
            return this;
        }

        public XdClues build() {
            return new XdClues(this.acrossClues, this.downClues);
        }

        public void reset() {
            this.acrossClues.clear();
            this.downClues.clear();
        }
    }
}

