/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import re.belv.croiseur.puzzle.codec.xd.model.XdClues;
import re.belv.croiseur.puzzle.codec.xd.model.XdCrossword;
import re.belv.croiseur.puzzle.codec.xd.model.XdGrid;
import re.belv.croiseur.puzzle.codec.xd.model.XdMetadata;
import re.belv.croiseur.puzzle.codec.xd.reader.XdCluesReader;
import re.belv.croiseur.puzzle.codec.xd.reader.XdCrosswordReadException;
import re.belv.croiseur.puzzle.codec.xd.reader.XdGridReader;
import re.belv.croiseur.puzzle.codec.xd.reader.XdMetadataReader;
import re.belv.croiseur.puzzle.codec.xd.reader.XdReadException;

public final class XdCrosswordReader {
    private final XdMetadataReader metadataReader = new XdMetadataReader();
    private final XdGridReader gridReader = new XdGridReader();
    private final XdCluesReader cluesReader = new XdCluesReader();

    public XdCrossword read(String rawCrossword) throws XdReadException {
        Sections sections = XdCrosswordReader.splitSections(rawCrossword);
        XdMetadata metadata = this.metadataReader.read(sections.metadata);
        XdGrid grid = this.gridReader.read(sections.grid);
        XdClues clues = this.cluesReader.read(sections.clues);
        return new XdCrossword(metadata, grid, clues);
    }

    public XdCrossword read(InputStream crosswordInputStream) throws XdReadException {
        try {
            byte[] bytes = crosswordInputStream.readAllBytes();
            String string = new String(bytes, StandardCharsets.UTF_8);
            return this.read(string);
        }
        catch (IOException e) {
            throw new XdCrosswordReadException(e);
        }
    }

    public XdCrossword read(Path crosswordPath) throws XdReadException {
        try {
            String rawCrossword = Files.readString(crosswordPath);
            return this.read(rawCrossword);
        }
        catch (IOException e) {
            throw new XdCrosswordReadException(e);
        }
    }

    private static Sections splitSections(String rawCrossword) throws XdCrosswordReadException {
        String[] sections = rawCrossword.split("\n\n\n");
        if (sections.length != 3 && sections.length != 4) {
            throw new XdCrosswordReadException("Failed to recognize crossword sections");
        }
        return new Sections(sections[0], sections[1], sections[2]);
    }

    private record Sections(String metadata, String grid, String clues) {
    }
}

