/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.reader;

import java.util.Objects;
import re.belv.croiseur.puzzle.codec.xd.model.XdGrid;

final class XdGridReader {
    private final XdGrid.Builder builder = new XdGrid.Builder();

    XdGridReader() {
    }

    XdGrid read(String rawGrid) {
        Objects.requireNonNull(rawGrid);
        this.builder.reset();
        String[] lines = rawGrid.split("\\R");
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            String line = lines[lineIndex];
            block6: for (int columnIndex = 0; columnIndex < line.length(); ++columnIndex) {
                char character = line.charAt(columnIndex);
                XdGrid.Index position = XdGrid.Index.at(columnIndex, lineIndex);
                switch (character) {
                    case '#': {
                        this.builder.block(position);
                        continue block6;
                    }
                    case '.': {
                        this.builder.nonFilled(position);
                        continue block6;
                    }
                    case '_': {
                        this.builder.space(position);
                        continue block6;
                    }
                    default: {
                        this.builder.filled(position, character);
                    }
                }
            }
        }
        return this.builder.build();
    }
}

