/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import re.belv.croiseur.puzzle.codec.xd.model.XdCrossword;
import re.belv.croiseur.puzzle.codec.xd.writer.XdCluesWriter;
import re.belv.croiseur.puzzle.codec.xd.writer.XdGridWriter;
import re.belv.croiseur.puzzle.codec.xd.writer.XdMetadataWriter;

public final class XdCrosswordWriter {
    private static final String SECTION_DELIMITER = "\n\n";
    private final XdMetadataWriter metadataWriter = new XdMetadataWriter();
    private final XdGridWriter gridWriter = new XdGridWriter();
    private final XdCluesWriter cluesWriter = new XdCluesWriter();

    public String write(XdCrossword crossword) {
        Objects.requireNonNull(crossword);
        return this.metadataWriter.write(crossword.metadata()) + SECTION_DELIMITER + this.gridWriter.write(crossword.grid()) + SECTION_DELIMITER + this.cluesWriter.write(crossword.clues());
    }

    public void write(XdCrossword crossword, Path path) throws IOException {
        Objects.requireNonNull(path);
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            this.write(crossword, outputStream);
        }
    }

    public void write(XdCrossword crossword, OutputStream outputStream) {
        Objects.requireNonNull(outputStream);
        String text = this.write(crossword);
        try (PrintWriter writer = new PrintWriter(outputStream, false, StandardCharsets.UTF_8);){
            writer.write(text);
            writer.flush();
        }
    }
}

