/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionModel;
import javafx.scene.layout.HBox;
import re.belv.croiseur.gui.view.ClueListCell;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;
import re.belv.croiseur.gui.view.model.ClueViewModel;

public final class CluesPane
extends HBox {
    private final ListProperty<ClueViewModel> acrossClues = new SimpleListProperty((Object)this, "acrossClues", FXCollections.observableArrayList());
    private final ListProperty<ClueViewModel> downClues = new SimpleListProperty((Object)this, "downClues", FXCollections.observableArrayList());
    private final IntegerProperty selectedAcrossClueIndex = new SimpleIntegerProperty((Object)this, "selectedAcrossClue", -1);
    private final IntegerProperty selectedDownClueIndex = new SimpleIntegerProperty((Object)this, "selectedDownClue", -1);
    private final ObjectProperty<EventHandler<ActionEvent>> onFillClueButtonAction = new SimpleObjectProperty((Object)this, "onFillClueButtonAction");
    private final BooleanProperty fillClueButtonDisable = new SimpleBooleanProperty((Object)this, "fillClueButtonDisable");
    private final BooleanProperty fillClueButtonHide = new SimpleBooleanProperty((Object)this, "fillClueButtonHide");
    @FXML
    private ListView<ClueViewModel> acrossClueListView;
    @FXML
    private ListView<ClueViewModel> downClueListView;

    public CluesPane() {
        FxmlLoaderHelper.load((Object)this, ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName()));
    }

    public ListProperty<ClueViewModel> acrossCluesProperty() {
        return this.acrossClues;
    }

    public ListProperty<ClueViewModel> downCluesProperty() {
        return this.downClues;
    }

    public IntegerProperty selectedAcrossClueIndexProperty() {
        return this.selectedAcrossClueIndex;
    }

    public IntegerProperty selectedDownClueIndexProperty() {
        return this.selectedDownClueIndex;
    }

    public ObjectProperty<EventHandler<ActionEvent>> onFillClueButtonActionProperty() {
        return this.onFillClueButtonAction;
    }

    public BooleanProperty fillClueButtonDisableProperty() {
        return this.fillClueButtonDisable;
    }

    public BooleanProperty fillClueButtonHideProperty() {
        return this.fillClueButtonHide;
    }

    @FXML
    private void initialize() {
        this.initializeAcrossClueListView();
        this.initializeDownClueListView();
    }

    private void initializeAcrossClueListView() {
        this.acrossClueListView.setCellFactory(l -> this.newClueListCell());
        this.acrossClues.addListener(this::clearAcrossViewSelectionUponItemDeletion);
        this.acrossClueListView.setItems(this.acrossClues);
        this.selectedAcrossClueIndex.addListener(this::updateViewAcrossSelectionUponModelSelectionIndexChange);
        this.acrossClueListView.getSelectionModel().selectedIndexProperty().addListener(this::updateAcrossModelSelectionUponViewSelectionIndexChange);
    }

    private void initializeDownClueListView() {
        this.downClueListView.setCellFactory(l -> this.newClueListCell());
        this.downClues.addListener(this::clearDownSelectionUponItemDeletion);
        this.downClueListView.setItems(this.downClues);
        this.selectedDownClueIndex.addListener(this::updateViewDownSelectionUponModelSelectionIndexChange);
        this.downClueListView.getSelectionModel().selectedIndexProperty().addListener(this::updateDownModelSelectionUponViewSelectionIndexChange);
    }

    private ClueListCell newClueListCell() {
        ClueListCell cell = new ClueListCell();
        cell.onFillClueButtonActionProperty().bind(this.onFillClueButtonAction);
        cell.fillClueButtonDisableProperty().bind((ObservableValue)this.fillClueButtonDisable);
        cell.fillButtonHideProperty().bind((ObservableValue)this.fillClueButtonHide);
        return cell;
    }

    private void clearAcrossViewSelectionUponItemDeletion(ListChangeListener.Change<? extends ClueViewModel> c) {
        this.clearViewSelectionUponItemDeletion(c, (SelectionModel<ClueViewModel>)this.acrossClueListView.getSelectionModel());
    }

    private void clearDownSelectionUponItemDeletion(ListChangeListener.Change<? extends ClueViewModel> c) {
        this.clearViewSelectionUponItemDeletion(c, (SelectionModel<ClueViewModel>)this.downClueListView.getSelectionModel());
    }

    private void clearViewSelectionUponItemDeletion(ListChangeListener.Change<? extends ClueViewModel> c, SelectionModel<ClueViewModel> viewSelection) {
        while (c.next()) {
            boolean selectionRemoved;
            boolean removedWithoutReplacement = c.wasRemoved() && !c.wasAdded();
            int selectedIndex = viewSelection.getSelectedIndex();
            boolean bl = selectionRemoved = selectedIndex >= c.getFrom() && selectedIndex < c.getFrom() + c.getRemovedSize();
            if (!removedWithoutReplacement || !selectionRemoved) continue;
            viewSelection.clearSelection();
        }
    }

    private void updateViewAcrossSelectionUponModelSelectionIndexChange(Observable observable) {
        this.updateViewSelectionUponModelSelectionIndexChange(this.selectedAcrossClueIndex.get(), (SelectionModel<ClueViewModel>)this.acrossClueListView.getSelectionModel());
    }

    private void updateViewDownSelectionUponModelSelectionIndexChange(Observable observable) {
        this.updateViewSelectionUponModelSelectionIndexChange(this.selectedDownClueIndex.get(), (SelectionModel<ClueViewModel>)this.downClueListView.getSelectionModel());
    }

    private void updateViewSelectionUponModelSelectionIndexChange(int modelNewSelectedIndex, SelectionModel<ClueViewModel> viewSelection) {
        if (modelNewSelectedIndex < 0) {
            viewSelection.clearSelection();
        } else {
            viewSelection.select(modelNewSelectedIndex);
        }
    }

    private void updateAcrossModelSelectionUponViewSelectionIndexChange(Observable observable) {
        this.updateModelSelectionUponViewSelectionIndexChange(this.selectedAcrossClueIndex, (SelectionModel<ClueViewModel>)this.acrossClueListView.getSelectionModel(), (SelectionModel<ClueViewModel>)this.downClueListView.getSelectionModel());
    }

    private void updateDownModelSelectionUponViewSelectionIndexChange(Observable observable) {
        this.updateModelSelectionUponViewSelectionIndexChange(this.selectedDownClueIndex, (SelectionModel<ClueViewModel>)this.downClueListView.getSelectionModel(), (SelectionModel<ClueViewModel>)this.acrossClueListView.getSelectionModel());
    }

    private void updateModelSelectionUponViewSelectionIndexChange(IntegerProperty modelSelectedIndex, SelectionModel<ClueViewModel> viewSelection, SelectionModel<ClueViewModel> otherViewSelection) {
        modelSelectedIndex.set(viewSelection.getSelectedIndex());
        if (modelSelectedIndex.get() >= 0) {
            otherViewSelection.clearSelection();
        }
    }
}

