/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.function.UnaryOperator;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyEvent;
import re.belv.croiseur.gui.view.model.CrosswordBoxViewModel;

public final class CrosswordBoxTextField
extends TextField {
    private static final String CSS_CLASS = "crossword-box-text";
    private static final PseudoClass SHADED = PseudoClass.getPseudoClass((String)"shaded");
    private static final PseudoClass UNSOLVABLE = PseudoClass.getPseudoClass((String)"unsolvable");
    private static final PseudoClass SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private static final String SHADE_KEY = " ";
    private static final UnaryOperator<TextFormatter.Change> LAST_CHARACTER_TO_UPPER_CASE = change -> {
        String newText = change.getControlNewText();
        int newTextLength = newText.length();
        if (newTextLength > 1) {
            String lastCharacter = newText.substring(newTextLength - 1, newTextLength);
            change.setText(lastCharacter);
            change.setRange(0, 1);
        }
        change.setText(change.getText().toUpperCase());
        return change;
    };
    private final CrosswordBoxViewModel model;

    CrosswordBoxTextField(CrosswordBoxViewModel modelArg) {
        this.model = modelArg;
        this.getStyleClass().add((Object)CSS_CLASS);
        this.pseudoClassStateChanged(SHADED, this.model.isShaded());
        this.pseudoClassStateChanged(UNSOLVABLE, this.model.isUnsolvable());
        this.pseudoClassStateChanged(SELECTED, this.model.isSelected());
        this.model.shadedProperty().addListener(e -> this.pseudoClassStateChanged(SHADED, this.model.isShaded()));
        this.model.unsolvableProperty().addListener(e -> this.pseudoClassStateChanged(UNSOLVABLE, this.model.isUnsolvable()));
        this.model.selectedProperty().addListener(e -> this.pseudoClassStateChanged(SELECTED, this.model.isSelected()));
        this.editableProperty().bind((ObservableValue)this.model.shadedProperty().not());
        this.setTextFormatter(new TextFormatter(LAST_CHARACTER_TO_UPPER_CASE));
        this.textProperty().bindBidirectional((Property)this.model.userContentProperty());
        this.promptTextProperty().bind((ObservableValue)this.model.solverContentProperty());
        DoubleBinding scaledFontSize = this.heightProperty().divide(2.2);
        StringExpression scaledFontSizeCss = Bindings.concat((Object[])new Object[]{"-fx-font-size: ", scaledFontSize.asString()});
        this.styleProperty().bind((ObservableValue)scaledFontSizeCss);
        this.setOnContextMenuRequested(event -> this.toggleShading());
        this.addEventFilter(KeyEvent.KEY_TYPED, event -> {
            if (event.getCharacter().equals(SHADE_KEY)) {
                this.toggleShading();
                event.consume();
            }
        });
    }

    private void toggleShading() {
        if (this.model.isShaded()) {
            this.model.lighten();
        } else {
            this.clear();
            this.model.solverContent("");
            this.model.shade();
        }
    }
}

