/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import re.belv.croiseur.gui.view.CluesPane;
import re.belv.croiseur.gui.view.CrosswordEditorToolbar;
import re.belv.croiseur.gui.view.CrosswordGridPane;
import re.belv.croiseur.gui.view.DictionariesPane;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;
import re.belv.croiseur.gui.view.PuzzlePane;
import re.belv.croiseur.gui.view.model.ClueViewModel;
import re.belv.croiseur.gui.view.model.CrosswordBoxViewModel;
import re.belv.croiseur.gui.view.model.DictionaryViewModel;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.SolverItemViewModel;

public final class CrosswordEditorPane
extends BorderPane {
    private static final String DIVIDER_SELECTOR = ".split-pane-divider";
    private static final int LEFT_DIVIDER_ID = 0;
    private static final int RIGHT_DIVIDER_ID = 1;
    private static final double LEFT_DIVIDER_COLLAPSED_POSITION = 0.0;
    private static final double RIGHT_DIVIDER_COLLAPSED_POSITION = 1.0;
    private static final double LEFT_DIVIDER_IDEAL_POSITION = 0.25;
    private static final double RIGHT_DIVIDER_IDEAL_POSITION = 0.75;
    @FXML
    private CrosswordEditorToolbar toolbar;
    @FXML
    private SplitPane centerSplitPane;
    @FXML
    private PuzzlePane puzzlePane;
    @FXML
    private CrosswordGridPane grid;
    @FXML
    private ProgressIndicator solverProgressIndicator;
    @FXML
    private DictionariesPane dictionariesPane;
    @FXML
    private CluesPane cluesPane;

    public CrosswordEditorPane() {
        FxmlLoaderHelper.load((Object)this);
    }

    public StringProperty puzzleTitleProperty() {
        return this.puzzlePane.titleProperty();
    }

    public StringProperty puzzleAuthorProperty() {
        return this.puzzlePane.authorProperty();
    }

    public StringProperty puzzleEditorProperty() {
        return this.puzzlePane.editorProperty();
    }

    public StringProperty puzzleCopyrightProperty() {
        return this.puzzlePane.copyrightProperty();
    }

    public StringProperty puzzleDateProperty() {
        return this.puzzlePane.dateProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onExportPuzzleButtonActionProperty() {
        return this.puzzlePane.onExportButtonActionProperty();
    }

    public BooleanProperty puzzleExportButtonDisableProperty() {
        return this.puzzlePane.exportButtonDisableProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onBackToPuzzleSelectionButtonActionProperty() {
        return this.puzzlePane.onBackToSelectionButtonActionProperty();
    }

    public BooleanProperty puzzleEditionDisableProperty() {
        return this.puzzlePane.disableProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onAddColumnActionButtonProperty() {
        return this.toolbar.onAddColumnActionButtonProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onDeleteColumnActionButtonProperty() {
        return this.toolbar.onDeleteColumnActionButtonProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onAddRowActionButtonProperty() {
        return this.toolbar.onAddRowActionButtonProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onDeleteRowActionButtonProperty() {
        return this.toolbar.onDeleteRowActionButtonProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onClearGridLettersFilledBySolverMenuItemActionProperty() {
        return this.toolbar.onClearGridLettersFilledBySolverMenuItemActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onClearGridAllLettersMenuItemActionProperty() {
        return this.toolbar.onClearGridAllLettersMenuItemActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onClearGridContentMenuItemActionProperty() {
        return this.toolbar.onClearGridContentMenuItemActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onDeleteGridActionProperty() {
        return this.toolbar.onDeleteGridActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onSolveButtonActionProperty() {
        return this.toolbar.onSolveButtonActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onSaveButtonActionProperty() {
        return this.toolbar.onSaveButtonActionProperty();
    }

    public BooleanProperty gridEditionDisableProperty() {
        return this.toolbar.editionButtonsDisableProperty();
    }

    public BooleanProperty solveButtonDisableProperty() {
        return this.toolbar.solveButtonDisableProperty();
    }

    public StringProperty solveButtonTextProperty() {
        return this.toolbar.solveButtonTextProperty();
    }

    public DoubleProperty solverProgressIndicatorValueProperty() {
        return this.solverProgressIndicator.progressProperty();
    }

    public BooleanProperty solverProgressIndicatorVisibleProperty() {
        return this.solverProgressIndicator.visibleProperty();
    }

    public MapProperty<GridCoord, CrosswordBoxViewModel> gridBoxesProperty() {
        return this.grid.boxesProperty();
    }

    public ObjectProperty<GridCoord> gridCurrentBoxProperty() {
        return this.grid.currentBoxPositionProperty();
    }

    public BooleanProperty gridCurrentSlotOrientationVerticalProperty() {
        return this.grid.currentSlotVerticalProperty();
    }

    public ListProperty<DictionaryViewModel> dictionariesProperty() {
        return this.dictionariesPane.dictionariesProperty();
    }

    public ListProperty<String> suggestionsProperty() {
        return this.dictionariesPane.suggestionsProperty();
    }

    public ObjectProperty<Consumer<String>> onSuggestionSelected() {
        return this.dictionariesPane.onSuggestionSelected();
    }

    public ListProperty<SolverItemViewModel> solversProperty() {
        return this.toolbar.solveButtonAvailableSolversProperty();
    }

    public ReadOnlyProperty<String> selectedSolverProperty() {
        return this.toolbar.solveButtonSelectedSolverProperty();
    }

    public ReadOnlyBooleanProperty fillClueOnSolverSuccessProperty() {
        return this.toolbar.fillClueOnSolverSuccessProperty();
    }

    public ListProperty<String> wordsProperty() {
        return this.dictionariesPane.wordsProperty();
    }

    public ListProperty<ClueViewModel> acrossCluesProperty() {
        return this.cluesPane.acrossCluesProperty();
    }

    public ListProperty<ClueViewModel> downCluesProperty() {
        return this.cluesPane.downCluesProperty();
    }

    public IntegerProperty selectedAcrossClueIndexProperty() {
        return this.cluesPane.selectedAcrossClueIndexProperty();
    }

    public IntegerProperty selectedDownClueIndexProperty() {
        return this.cluesPane.selectedDownClueIndexProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onFillClueButtonActionProperty() {
        return this.cluesPane.onFillClueButtonActionProperty();
    }

    public BooleanProperty fillClueButtonHideProperty() {
        return this.cluesPane.fillClueButtonHideProperty();
    }

    public BooleanProperty fillClueButtonDisableProperty() {
        return this.cluesPane.fillClueButtonDisableProperty();
    }

    public BooleanProperty clueEditionDisableProperty() {
        return this.cluesPane.disableProperty();
    }

    public void resetLateralPanePositions() {
        this.toolbar.puzzleToggleButtonSelectedProperty().set(false);
        this.toolbar.dictionariesToggleButtonSelectedProperty().set(false);
    }

    @FXML
    private void initialize() {
        this.initializeToolbarPuzzlePaneBindings();
        this.initializeToolbarGridPaneBindings();
        this.initializeToolbarDictionariesPaneBindings();
        this.initializePuzzlePaneSplitPaneBindings();
        this.initializeDictionariesPaneSplitPaneBindings();
    }

    private void initializeToolbarPuzzlePaneBindings() {
        BooleanBinding puzzleToggleButtonSelectedProperty = this.toolbar.puzzleToggleButtonSelectedProperty().and((ObservableBooleanValue)this.toolbar.resizeModeProperty().not());
        this.puzzlePane.visibleProperty().bind((ObservableValue)puzzleToggleButtonSelectedProperty);
        this.puzzlePane.managedProperty().bind((ObservableValue)puzzleToggleButtonSelectedProperty);
    }

    private void initializeToolbarGridPaneBindings() {
        this.grid.disableProperty().bind((ObservableValue)this.toolbar.editionButtonsDisableProperty());
    }

    private void initializeToolbarDictionariesPaneBindings() {
        BooleanBinding dictionariesToggleButtonSelectedProperty = this.toolbar.dictionariesToggleButtonSelectedProperty().and((ObservableBooleanValue)this.toolbar.resizeModeProperty().not());
        this.dictionariesPane.visibleProperty().bind((ObservableValue)dictionariesToggleButtonSelectedProperty);
        this.dictionariesPane.managedProperty().bind((ObservableValue)dictionariesToggleButtonSelectedProperty);
    }

    private void initializePuzzlePaneSplitPaneBindings() {
        this.updateLeftDividerPosition();
        InvalidationListener updateLeftDividerNodeOnFirstShow = new InvalidationListener(this){
            final /* synthetic */ CrosswordEditorPane this$0;
            {
                CrosswordEditorPane crosswordEditorPane = this$0;
                Objects.requireNonNull(crosswordEditorPane);
                this.this$0 = crosswordEditorPane;
            }

            public void invalidated(Observable observable) {
                Platform.runLater(() -> this.this$0.updateLeftDividerNode());
                observable.removeListener((InvalidationListener)this);
            }
        };
        this.centerSplitPane.layoutBoundsProperty().addListener(updateLeftDividerNodeOnFirstShow);
        this.puzzlePane.visibleProperty().addListener(observable -> this.updateLeftDivider());
    }

    private void updateLeftDivider() {
        this.updateLeftDividerNode();
        this.updateLeftDividerPosition();
    }

    private void updateLeftDividerNode() {
        boolean puzzlePaneVisible = this.puzzlePane.isVisible();
        Node dividerNode = this.dividerNodeOf(0);
        dividerNode.setVisible(puzzlePaneVisible);
        dividerNode.setManaged(puzzlePaneVisible);
    }

    private void updateLeftDividerPosition() {
        boolean puzzlePaneVisible = this.puzzlePane.isVisible();
        this.centerSplitPane.setDividerPosition(0, puzzlePaneVisible ? 0.25 : 0.0);
    }

    private void initializeDictionariesPaneSplitPaneBindings() {
        this.updateRightDividerPosition();
        InvalidationListener updateRightDividerNodeOnFirstShow = new InvalidationListener(this){
            final /* synthetic */ CrosswordEditorPane this$0;
            {
                CrosswordEditorPane crosswordEditorPane = this$0;
                Objects.requireNonNull(crosswordEditorPane);
                this.this$0 = crosswordEditorPane;
            }

            public void invalidated(Observable observable) {
                Platform.runLater(() -> this.this$0.updateRightDividerNode());
                observable.removeListener((InvalidationListener)this);
            }
        };
        this.centerSplitPane.layoutBoundsProperty().addListener(updateRightDividerNodeOnFirstShow);
        this.dictionariesPane.visibleProperty().addListener(observable -> this.updateRightDivider());
    }

    private void updateRightDivider() {
        this.updateRightDividerNode();
        this.updateRightDividerPosition();
    }

    private void updateRightDividerNode() {
        boolean dictionariesPaneVisible = this.dictionariesPane.isVisible();
        Node dividerNode = this.dividerNodeOf(1);
        dividerNode.setVisible(dictionariesPaneVisible);
        dividerNode.setManaged(dictionariesPaneVisible);
    }

    private void updateRightDividerPosition() {
        boolean dictionariesPaneVisible = this.dictionariesPane.isVisible();
        this.centerSplitPane.setDividerPosition(1, dictionariesPaneVisible ? 0.75 : 1.0);
    }

    private Node dividerNodeOf(int dividerId) {
        Set dividers = this.centerSplitPane.lookupAll(DIVIDER_SELECTOR);
        double normalizedX = this.centerSplitPane.getDividerPositions()[dividerId];
        double x = this.getScene().getWidth() * normalizedX;
        return dividers.stream().filter(node -> {
            Bounds boundsInLocal = node.getBoundsInLocal();
            Bounds boundsInScene = node.localToScene(boundsInLocal);
            return boundsInScene.getMinX() <= x && x <= boundsInScene.getMaxX();
        }).findFirst().orElseThrow();
    }
}

