/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;

public final class PuzzlePane
extends Accordion {
    @FXML
    private TextField title;
    @FXML
    private TextField author;
    @FXML
    private TextField editor;
    @FXML
    private TextField copyright;
    @FXML
    private DatePicker date;
    @FXML
    private Button exportButton;
    @FXML
    private Button backToSelectionButton;

    public PuzzlePane() {
        FxmlLoaderHelper.load((Object)this, ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName()));
    }

    public StringProperty titleProperty() {
        return this.title.textProperty();
    }

    public StringProperty authorProperty() {
        return this.author.textProperty();
    }

    public StringProperty editorProperty() {
        return this.editor.textProperty();
    }

    public StringProperty copyrightProperty() {
        return this.copyright.textProperty();
    }

    public StringProperty dateProperty() {
        return this.date.getEditor().textProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onExportButtonActionProperty() {
        return this.exportButton.onActionProperty();
    }

    public BooleanProperty exportButtonDisableProperty() {
        return this.exportButton.disableProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onBackToSelectionButtonActionProperty() {
        return this.backToSelectionButton.onActionProperty();
    }

    @FXML
    private void initialize() {
        this.initializeTitledPanes();
        this.initializeDatePicker();
    }

    private void initializeTitledPanes() {
        this.expandedPaneProperty().addListener((observable, oldValue, newValue) -> {
            boolean hasExpanded = this.getPanes().stream().anyMatch(TitledPane::isExpanded);
            if (!hasExpanded && oldValue != null) {
                Platform.runLater(() -> this.setExpandedPane((TitledPane)oldValue));
            }
        });
        this.setExpandedPane((TitledPane)this.getPanes().get(0));
    }

    private void initializeDatePicker() {
        this.date.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            KeyCode keyCode = e.getCode();
            if (keyCode == KeyCode.BACK_SPACE || keyCode == KeyCode.DELETE) {
                this.date.getEditor().clear();
                this.date.setValue(null);
            }
        });
    }
}

