/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;
import re.belv.croiseur.gui.view.SavedPuzzleListCell;
import re.belv.croiseur.gui.view.model.SavedPuzzleViewModel;

public final class SavedPuzzleSelector
extends VBox {
    private final ListProperty<SavedPuzzleViewModel> recentPuzzles = new SimpleListProperty((Object)this, "recentPuzzles", FXCollections.observableArrayList());
    private final ObjectProperty<EventHandler<ActionEvent>> onOpenSelectedPuzzleButtonAction = new SimpleObjectProperty((Object)this, "onEditSelectedPuzzleButtonAction");
    private final ObjectProperty<EventHandler<ActionEvent>> onDeleteSelectedPuzzleButtonAction = new SimpleObjectProperty((Object)this, "onDeleteSelectedPuzzleButtonAction");
    @FXML
    private TextField searchTextField;
    @FXML
    private Button newPuzzleButton;
    @FXML
    private Button importPuzzleButton;
    @FXML
    private ListView<SavedPuzzleViewModel> recentPuzzleListView;

    public SavedPuzzleSelector() {
        FxmlLoaderHelper.load((Object)this, ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName()));
    }

    public ObjectProperty<EventHandler<ActionEvent>> onNewPuzzleButtonActionProperty() {
        return this.newPuzzleButton.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onImportPuzzleButtonActionProperty() {
        return this.importPuzzleButton.onActionProperty();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onOpenSelectedPuzzleButtonActionProperty() {
        return this.onOpenSelectedPuzzleButtonAction;
    }

    public ObjectProperty<EventHandler<ActionEvent>> onDeleteSelectedPuzzleButtonActionProperty() {
        return this.onDeleteSelectedPuzzleButtonAction;
    }

    public ListProperty<SavedPuzzleViewModel> recentPuzzles() {
        return this.recentPuzzles;
    }

    public ReadOnlyProperty<SavedPuzzleViewModel> selectedPuzzleProperty() {
        return this.recentPuzzleListView.getSelectionModel().selectedItemProperty();
    }

    @FXML
    private void initialize() {
        this.initializeListViewCells();
        this.initializeListViewSearch();
    }

    private void initializeListViewCells() {
        this.recentPuzzleListView.setCellFactory(l -> {
            SavedPuzzleListCell listCell = new SavedPuzzleListCell();
            listCell.onOpenButtonActionProperty().bind(this.onOpenSelectedPuzzleButtonAction);
            listCell.onDeleteButtonActionProperty().bind(this.onDeleteSelectedPuzzleButtonAction);
            return listCell;
        });
    }

    private void initializeListViewSearch() {
        FilteredList filteredPuzzles = new FilteredList(this.recentPuzzles);
        ObjectBinding searchPredicate = Bindings.createObjectBinding(this::createSearchPredicate, (Observable[])new Observable[]{this.searchTextField.textProperty()});
        filteredPuzzles.predicateProperty().bind((ObservableValue)searchPredicate);
        this.recentPuzzleListView.setItems((ObservableList)filteredPuzzles);
    }

    private Predicate<SavedPuzzleViewModel> createSearchPredicate() {
        return puzzle -> {
            String searchText = this.searchTextField.getText().toLowerCase();
            return Stream.of(puzzle.title(), puzzle.author(), puzzle.editor(), puzzle.copyright(), puzzle.date()).anyMatch(text -> text.toLowerCase().contains(searchText));
        };
    }
}

