/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;
import re.belv.croiseur.gui.view.model.SolverItemViewModel;

public final class SolveSplitMenuButton
extends SplitMenuButton {
    private static final int STATIC_ITEMS = 2;
    private final ListProperty<SolverItemViewModel> availableSolvers = new SimpleListProperty((Object)this, "availableSolvers", FXCollections.observableArrayList());
    private final ReadOnlyStringWrapper selectedSolver = new ReadOnlyStringWrapper((Object)this, "selectedSolver");
    private final ToggleGroup toggleGroup = new ToggleGroup();
    @FXML
    private CheckMenuItem fillCluesOnSuccessMenuItem;

    public SolveSplitMenuButton() {
        FxmlLoaderHelper.load((Object)this, ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName()));
    }

    public ReadOnlyStringProperty selectedSolverProperty() {
        return this.selectedSolver.getReadOnlyProperty();
    }

    public ListProperty<SolverItemViewModel> availableSolversProperty() {
        return this.availableSolvers;
    }

    public BooleanProperty getCluesOnSuccessProperty() {
        return this.fillCluesOnSuccessMenuItem.selectedProperty();
    }

    @FXML
    private void initialize() {
        this.availableSolvers.addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                c.getAddedSubList().forEach(this::addMenuItem);
            }
        });
    }

    private void addMenuItem(SolverItemViewModel solver) {
        RadioMenuItem item = SolveSplitMenuButton.createMenuItem(solver);
        item.setToggleGroup(this.toggleGroup);
        item.setOnAction(event -> this.selectedSolver.set(solver.name()));
        ObservableList items = this.getItems();
        items.add(items.size() - 2, item);
        if (items.size() == 3) {
            item.setSelected(true);
        }
    }

    private static RadioMenuItem createMenuItem(SolverItemViewModel solver) {
        Label label = new Label(solver.name());
        Tooltip tooltip = new Tooltip(solver.description());
        label.setTooltip(tooltip);
        return new RadioMenuItem(null, (Node)label);
    }
}

