/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.sat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import re.belv.croiseur.solver.sat.Alphabet;
import re.belv.croiseur.solver.sat.Slot;

final class Grid {
    static final char BLOCK = '#';
    static final char EMPTY = '.';
    private final char[][] cells;
    private final List<Slot> slots;

    Grid(char[][] cellsArg) {
        this.cells = Grid.validateGrid(cellsArg);
        this.slots = Grid.slotsFrom(cellsArg);
    }

    private static char[][] validateGrid(char[][] cells) {
        Objects.requireNonNull(cells);
        if (cells.length == 0) {
            return cells;
        }
        int firstRowNumberOfColumns = cells[0].length;
        for (int row = 0; row < cells.length; ++row) {
            int numberOfColumns = cells[row].length;
            if (numberOfColumns != firstRowNumberOfColumns) {
                throw new IllegalArgumentException("Inconsistent number of columns: Row #" + row + " has " + numberOfColumns + " columns but row #0 has " + firstRowNumberOfColumns);
            }
            for (int column = 0; column < numberOfColumns; ++column) {
                char value = cells[row][column];
                if (value == '.' || value == '#' || Alphabet.contains(value)) continue;
                throw new IllegalArgumentException("Invalid value at row #" + row + ", column #" + column + ": " + value);
            }
        }
        return cells;
    }

    private static List<Slot> slotsFrom(char[][] cells) {
        List<Slot> acrossSlots = Grid.acrossSlotsFrom(cells);
        List<Slot> downSlots = Grid.downSlotsFrom(acrossSlots.size(), cells);
        return Stream.concat(acrossSlots.stream(), downSlots.stream()).toList();
    }

    private static List<Slot> acrossSlotsFrom(char[][] cells) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int numberOfRows = cells.length;
        int numberOfColumns = cells.length > 0 ? cells[0].length : 0;
        for (int row = 0; row < numberOfRows; ++row) {
            int columnStart;
            for (int column = columnStart = 0; column < numberOfColumns; ++column) {
                if (cells[row][column] != '#') continue;
                if (column - columnStart >= 2) {
                    slots.add(Slot.across(slots.size(), columnStart, column, row));
                }
                columnStart = column + 1;
            }
            if (numberOfColumns - columnStart < 2) continue;
            slots.add(Slot.across(slots.size(), columnStart, numberOfColumns, row));
        }
        return slots;
    }

    private static List<Slot> downSlotsFrom(int startIndex, char[][] cells) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int numberOfRows = cells.length;
        int numberOfColumns = cells.length > 0 ? cells[0].length : 0;
        for (int column = 0; column < numberOfColumns; ++column) {
            int rowStart;
            for (int row = rowStart = 0; row < numberOfRows; ++row) {
                if (cells[row][column] != '#') continue;
                if (row - rowStart >= 2) {
                    slots.add(Slot.down(startIndex + slots.size(), rowStart, row, column));
                }
                rowStart = row + 1;
            }
            if (numberOfRows - rowStart < 2) continue;
            slots.add(Slot.down(startIndex + slots.size(), rowStart, numberOfRows, column));
        }
        return slots;
    }

    char letterAt(int row, int column) {
        return this.cells[row][column];
    }

    int rowCount() {
        return this.cells.length;
    }

    int columnCount() {
        return this.cells.length == 0 ? 0 : this.cells[0].length;
    }

    List<Slot> slots() {
        return this.slots;
    }

    int slotCount() {
        return this.slots.size();
    }

    public String toString() {
        return "Grid{cells=" + Arrays.deepToString((Object[])this.cells) + "}";
    }
}

