/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.sat;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;
import re.belv.croiseur.solver.sat.Constraints;
import re.belv.croiseur.solver.sat.Grid;
import re.belv.croiseur.solver.sat.Pos;
import re.belv.croiseur.solver.sat.Variables;

public final class Solver {
    private final IPBSolver satSolver;
    private final Variables variables;
    private final Constraints constraints;

    public Solver(char[][] cells, String[] words) {
        Objects.requireNonNull(words);
        Grid grid = new Grid(cells);
        this.variables = new Variables(grid, words.length);
        this.constraints = new Constraints(grid, words, this.variables);
        this.satSolver = SolverFactory.newDefault();
    }

    public Result solve() throws InterruptedException {
        try {
            this.allocateVariables();
            this.addClauses();
            return this.findSolution();
        }
        catch (ContradictionException e) {
            return Result.unsat();
        }
    }

    private void allocateVariables() {
        int numberOfVariables = this.variables.count();
        this.satSolver.newVar(numberOfVariables);
    }

    private void addClauses() throws ContradictionException, InterruptedException {
        this.constraints.addOneLetterOrBlockPerCellClausesTo(this.satSolver);
        this.constraints.addOneWordPerSlotClausesTo(this.satSolver);
    }

    private Result findSolution() throws InterruptedException {
        if (!this.problemIsSatisfiable()) {
            IVecInt unsatExplanation = this.satSolver.unsatExplanation();
            Set<Pos> nonAssignablePositions = this.variables.backToPositions(unsatExplanation);
            return Result.unsat(nonAssignablePositions);
        }
        char[][] solution = this.variables.backToGrid(arg_0 -> ((IPBSolver)this.satSolver).model(arg_0));
        return Result.sat(solution);
    }

    private boolean problemIsSatisfiable() throws InterruptedException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            IVecInt inputGridConstraints = this.constraints.inputGridConstraintsAreSatisfied();
            boolean bl = executor.submit(() -> this.satSolver.isSatisfiable(inputGridConstraints)).get();
            if (executor != null) {
                executor.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (executor != null) {
                    try {
                        executor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
            catch (InterruptedException e) {
                this.satSolver.expireTimeout();
                throw e;
            }
        }
    }

    public static sealed interface Result {
        public static Sat sat(char[][] grid) {
            return new Sat(grid);
        }

        public static Unsat unsat() {
            return new Unsat(Set.of());
        }

        public static Unsat unsat(Set<Pos> nonAssignablePositions) {
            return new Unsat(nonAssignablePositions);
        }

        public record Sat(char[][] grid) implements Result
        {
            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object other) {
                char[][] otherGrid;
                if (other == this) {
                    return true;
                }
                if (!(other instanceof Sat)) return false;
                Sat sat = (Sat)other;
                try {
                    char[][] cArray;
                    otherGrid = cArray = sat.grid();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                return Arrays.deepEquals((Object[])this.grid, (Object[])otherGrid);
            }

            @Override
            public int hashCode() {
                return Arrays.deepHashCode((Object[])this.grid);
            }

            @Override
            public String toString() {
                return "Sat{grid=" + Arrays.deepToString((Object[])this.grid) + "}";
            }
        }

        public record Unsat(Set<Pos> nonAssignablePositions) implements Result
        {
        }
    }
}

