/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AzureChatExtensionRetrieveDocumentFilterReason;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AzureChatExtensionRetrievedDocument
implements JsonSerializable<AzureChatExtensionRetrievedDocument> {
    private final String content;
    private String title;
    private String url;
    private String filepath;
    private String chunkId;
    private final List<String> searchQueries;
    private final int dataSourceIndex;
    private Double originalSearchScore;
    private Double rerankScore;
    private AzureChatExtensionRetrieveDocumentFilterReason filterReason;

    private AzureChatExtensionRetrievedDocument(String content, List<String> searchQueries, int dataSourceIndex) {
        this.content = content;
        this.searchQueries = searchQueries;
        this.dataSourceIndex = dataSourceIndex;
    }

    public String getContent() {
        return this.content;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getChunkId() {
        return this.chunkId;
    }

    public List<String> getSearchQueries() {
        return this.searchQueries;
    }

    public int getDataSourceIndex() {
        return this.dataSourceIndex;
    }

    public Double getOriginalSearchScore() {
        return this.originalSearchScore;
    }

    public Double getRerankScore() {
        return this.rerankScore;
    }

    public AzureChatExtensionRetrieveDocumentFilterReason getFilterReason() {
        return this.filterReason;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("search_queries", this.searchQueries, (writer, element) -> writer.writeString(element));
        jsonWriter.writeIntField("data_source_index", this.dataSourceIndex);
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("filepath", this.filepath);
        jsonWriter.writeStringField("chunk_id", this.chunkId);
        jsonWriter.writeNumberField("rerank_score", (Number)this.rerankScore);
        jsonWriter.writeNumberField("original_search_score", (Number)this.originalSearchScore);
        jsonWriter.writeStringField("filter_reason", this.filterReason == null ? null : this.filterReason.toString());
        return jsonWriter.writeEndObject();
    }

    public static AzureChatExtensionRetrievedDocument fromJson(JsonReader jsonReader) throws IOException {
        return (AzureChatExtensionRetrievedDocument)jsonReader.readObject(reader -> {
            String content = null;
            List searchQueries = null;
            int dataSourceIndex = 0;
            String title = null;
            String url = null;
            String filepath = null;
            String chunkId = null;
            Double rerankScore = null;
            Double originalSearchScore = null;
            AzureChatExtensionRetrieveDocumentFilterReason filterReason = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("search_queries".equals(fieldName)) {
                    searchQueries = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("data_source_index".equals(fieldName)) {
                    dataSourceIndex = reader.getInt();
                    continue;
                }
                if ("title".equals(fieldName)) {
                    title = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    continue;
                }
                if ("filepath".equals(fieldName)) {
                    filepath = reader.getString();
                    continue;
                }
                if ("chunk_id".equals(fieldName)) {
                    chunkId = reader.getString();
                    continue;
                }
                if ("rerank_score".equals(fieldName)) {
                    rerankScore = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("original_search_score".equals(fieldName)) {
                    originalSearchScore = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("filter_reason".equals(fieldName)) {
                    filterReason = AzureChatExtensionRetrieveDocumentFilterReason.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            AzureChatExtensionRetrievedDocument deserializedAzureChatExtensionRetrievedDocument = new AzureChatExtensionRetrievedDocument(content, searchQueries, dataSourceIndex);
            deserializedAzureChatExtensionRetrievedDocument.title = title;
            deserializedAzureChatExtensionRetrievedDocument.url = url;
            deserializedAzureChatExtensionRetrievedDocument.filepath = filepath;
            deserializedAzureChatExtensionRetrievedDocument.chunkId = chunkId;
            deserializedAzureChatExtensionRetrievedDocument.rerankScore = rerankScore;
            deserializedAzureChatExtensionRetrievedDocument.originalSearchScore = originalSearchScore;
            deserializedAzureChatExtensionRetrievedDocument.filterReason = filterReason;
            return deserializedAzureChatExtensionRetrievedDocument;
        });
    }
}

