/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ContentFilterCompletionTextSpan
implements JsonSerializable<ContentFilterCompletionTextSpan> {
    private final int completionStartOffset;
    private final int completionEndOffset;

    private ContentFilterCompletionTextSpan(int completionStartOffset, int completionEndOffset) {
        this.completionStartOffset = completionStartOffset;
        this.completionEndOffset = completionEndOffset;
    }

    public int getCompletionStartOffset() {
        return this.completionStartOffset;
    }

    public int getCompletionEndOffset() {
        return this.completionEndOffset;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("completion_start_offset", this.completionStartOffset);
        jsonWriter.writeIntField("completion_end_offset", this.completionEndOffset);
        return jsonWriter.writeEndObject();
    }

    public static ContentFilterCompletionTextSpan fromJson(JsonReader jsonReader) throws IOException {
        return (ContentFilterCompletionTextSpan)jsonReader.readObject(reader -> {
            int completionStartOffset = 0;
            int completionEndOffset = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("completion_start_offset".equals(fieldName)) {
                    completionStartOffset = reader.getInt();
                    continue;
                }
                if ("completion_end_offset".equals(fieldName)) {
                    completionEndOffset = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new ContentFilterCompletionTextSpan(completionStartOffset, completionEndOffset);
        });
    }
}

