/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesFunctionCallOutputStatus;
import com.azure.ai.openai.responses.models.ResponsesItem;
import com.azure.ai.openai.responses.models.ResponsesItemType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesFunctionCallOutput
extends ResponsesItem {
    private ResponsesItemType type = ResponsesItemType.FUNCTION_CALL_OUTPUT;
    private ResponsesFunctionCallOutputStatus status;
    private final String callId;
    private final String output;

    public ResponsesFunctionCallOutput(String callId, String output) {
        this.callId = callId;
        this.output = output;
    }

    @Override
    public ResponsesItemType getType() {
        return this.type;
    }

    public ResponsesFunctionCallOutputStatus getStatus() {
        return this.status;
    }

    public String getCallId() {
        return this.callId;
    }

    public String getOutput() {
        return this.output;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("call_id", this.callId);
        jsonWriter.writeStringField("output", this.output);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesFunctionCallOutput fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesFunctionCallOutput)jsonReader.readObject(reader -> {
            String id = null;
            String callId = null;
            String output = null;
            ResponsesItemType type = ResponsesItemType.FUNCTION_CALL_OUTPUT;
            ResponsesFunctionCallOutputStatus status = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("call_id".equals(fieldName)) {
                    callId = reader.getString();
                    continue;
                }
                if ("output".equals(fieldName)) {
                    output = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesItemType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = ResponsesFunctionCallOutputStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesFunctionCallOutput deserializedResponsesFunctionCallOutput = new ResponsesFunctionCallOutput(callId, output);
            deserializedResponsesFunctionCallOutput.setId(id);
            deserializedResponsesFunctionCallOutput.type = type;
            deserializedResponsesFunctionCallOutput.status = status;
            return deserializedResponsesFunctionCallOutput;
        });
    }
}

