/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventError
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.ERROR;
    private final String message;
    private final String code;
    private final String param;

    private ResponsesStreamEventError(String message, String code, String param) {
        this.message = message;
        this.code = code;
        this.param = param;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public String getParam() {
        return this.param;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("param", this.param);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventError fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventError)jsonReader.readObject(reader -> {
            String message = null;
            String code = null;
            String param = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.ERROR;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    continue;
                }
                if ("param".equals(fieldName)) {
                    param = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventError deserializedResponsesStreamEventError = new ResponsesStreamEventError(message, code, param);
            deserializedResponsesStreamEventError.type = type;
            return deserializedResponsesStreamEventError;
        });
    }
}

