/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesTextFormat;
import com.azure.ai.openai.responses.models.ResponsesTextFormatType;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesTextFormatJsonSchema
extends ResponsesTextFormat {
    private ResponsesTextFormatType type = ResponsesTextFormatType.JSON_SCHEMA;
    private final String name;
    private final BinaryData schema;
    private String description;
    private Boolean strict;

    public ResponsesTextFormatJsonSchema(String name, BinaryData schema) {
        this.name = name;
        this.schema = schema;
    }

    @Override
    public ResponsesTextFormatType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public BinaryData getSchema() {
        return this.schema;
    }

    public String getDescription() {
        return this.description;
    }

    public ResponsesTextFormatJsonSchema setDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean isStrict() {
        return this.strict;
    }

    public ResponsesTextFormatJsonSchema setStrict(Boolean strict) {
        this.strict = strict;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeFieldName("schema");
        this.schema.writeTo(jsonWriter);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeBooleanField("strict", this.strict);
        return jsonWriter.writeEndObject();
    }

    public static ResponsesTextFormatJsonSchema fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesTextFormatJsonSchema)jsonReader.readObject(reader -> {
            String name = null;
            BinaryData schema = null;
            ResponsesTextFormatType type = ResponsesTextFormatType.JSON_SCHEMA;
            String description = null;
            Boolean strict = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    schema = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesTextFormatType.fromString(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("strict".equals(fieldName)) {
                    strict = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesTextFormatJsonSchema deserializedResponsesTextFormatJsonSchema = new ResponsesTextFormatJsonSchema(name, schema);
            deserializedResponsesTextFormatJsonSchema.type = type;
            deserializedResponsesTextFormatJsonSchema.description = description;
            deserializedResponsesTextFormatJsonSchema.strict = strict;
            return deserializedResponsesTextFormatJsonSchema;
        });
    }
}

