/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.xml.codec;

import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import re.belv.croiseur.dictionary.xml.codec.DictionaryHeader;
import re.belv.croiseur.dictionary.xml.codec.DictionaryHeaderReader;
import re.belv.croiseur.dictionary.xml.codec.DictionaryReadException;
import re.belv.croiseur.dictionary.xml.codec.DictionaryWordsReader;
import re.belv.croiseur.dictionary.xml.codec.InputStreamSupplier;

public final class DictionaryReader {
    private static final Logger LOGGER = Logger.getLogger(DictionaryReader.class.getName());
    private final DictionaryHeaderReader dictionaryHeaderReader;
    private final DictionaryWordsReader dictionaryWordsReader;

    public DictionaryReader(InputStreamSupplier dictionaryStreamArg) {
        InputStreamSupplier dictionaryStream = Objects.requireNonNull(dictionaryStreamArg);
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        xmlInputFactory.setXMLReporter((message, errorType, relatedInformation, location) -> LOGGER.warning("Error " + errorType + " while parsing XML dictionary at location " + String.valueOf(location) + ": " + message));
        this.dictionaryHeaderReader = new DictionaryHeaderReader(xmlInputFactory, dictionaryStream);
        this.dictionaryWordsReader = new DictionaryWordsReader(xmlInputFactory, dictionaryStream);
    }

    public DictionaryHeader readHeader() throws DictionaryReadException {
        long before = System.currentTimeMillis();
        try {
            DictionaryHeader dictionaryHeader = this.dictionaryHeaderReader.read();
            return dictionaryHeader;
        }
        catch (IOException | XMLStreamException e) {
            throw new DictionaryReadException(e);
        }
        finally {
            LOGGER.fine(() -> "Read header in " + (System.currentTimeMillis() - before) + " ms");
        }
    }

    public Stream<String> readWords() throws DictionaryReadException {
        long before = System.currentTimeMillis();
        try {
            Stream<String> stream = this.dictionaryWordsReader.read();
            return stream;
        }
        catch (IOException | XMLStreamException e) {
            throw new DictionaryReadException(e);
        }
        finally {
            LOGGER.fine(() -> "Read words in " + (System.currentTimeMillis() - before) + " ms");
        }
    }
}

