/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.presenter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javafx.application.Platform;
import re.belv.croiseur.gui.view.model.CluesViewModel;
import re.belv.croiseur.gui.view.model.CrosswordGridViewModel;
import re.belv.croiseur.gui.view.model.ErrorsViewModel;
import re.belv.croiseur.spi.presenter.clue.CluePresenter;
import re.belv.croiseur.spi.presenter.clue.ClueProviderDescription;

final class GuiCluePresenter
implements CluePresenter {
    private static final Logger LOGGER = Logger.getLogger(GuiCluePresenter.class.getName());
    private final CluesViewModel cluesViewModel;
    private final CrosswordGridViewModel gridViewModel;
    private final ErrorsViewModel errorsViewModel;

    GuiCluePresenter(CluesViewModel cluesViewModelArg, CrosswordGridViewModel gridViewModelArg, ErrorsViewModel errorsViewModelArg) {
        this.cluesViewModel = cluesViewModelArg;
        this.gridViewModel = gridViewModelArg;
        this.errorsViewModel = errorsViewModelArg;
    }

    public void presentClueError(String error) {
        LOGGER.warning(() -> "Received clue error: " + error);
        Platform.runLater(() -> this.errorsViewModel.addError(error));
    }

    public void presentClueProviders(List<ClueProviderDescription> clueProviderDescriptions) {
        LOGGER.info(() -> "Received clue providers: " + String.valueOf(clueProviderDescriptions));
        List<String> clueProviderNames = clueProviderDescriptions.stream().map(ClueProviderDescription::name).toList();
        Platform.runLater(() -> this.cluesViewModel.clueProvidersProperty().setAll((Collection)clueProviderNames));
    }

    public void presentClues(Map<String, String> clues) {
        LOGGER.info(() -> "Received clues: " + String.valueOf(clues));
        Platform.runLater(() -> this.fillCluesViewModel(clues));
    }

    private void fillCluesViewModel(Map<String, String> clues) {
        List acrossSlotContents = this.gridViewModel.longAcrossSlotContents();
        for (int i = 0; i < acrossSlotContents.size(); ++i) {
            String word = (String)acrossSlotContents.get(i);
            String clue = clues.get(word);
            if (clue == null) continue;
            this.cluesViewModel.acrossClue(i).systemContent(clue);
        }
        List downSlotContents = this.gridViewModel.longDownSlotContents();
        for (int i = 0; i < downSlotContents.size(); ++i) {
            String word = (String)downSlotContents.get(i);
            String clue = clues.get(word);
            if (clue == null) continue;
            this.cluesViewModel.downClue(i).systemContent(clue);
        }
    }
}

