/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.presenter;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javafx.application.Platform;
import re.belv.croiseur.common.dictionary.DictionaryProviderDetails;
import re.belv.croiseur.common.dictionary.ProvidedDictionaryDetails;
import re.belv.croiseur.gui.view.model.DictionariesViewModel;
import re.belv.croiseur.gui.view.model.DictionaryKey;
import re.belv.croiseur.gui.view.model.DictionaryViewModel;
import re.belv.croiseur.gui.view.model.ErrorsViewModel;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryContent;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryPresenter;
import re.belv.croiseur.spi.presenter.dictionary.DictionarySearchResult;

final class GuiDictionaryPresenter
implements DictionaryPresenter {
    private static final Logger LOGGER = Logger.getLogger(GuiDictionaryPresenter.class.getName());
    private final DictionariesViewModel dictionariesViewModel;
    private final ErrorsViewModel errorsViewModel;

    GuiDictionaryPresenter(DictionariesViewModel dictionariesViewModelArg, ErrorsViewModel errorsViewModelArg) {
        this.dictionariesViewModel = dictionariesViewModelArg;
        this.errorsViewModel = errorsViewModelArg;
    }

    public void presentDictionaryProviders(Collection<DictionaryProviderDetails> providers) {
        throw new UnsupportedOperationException("Not used");
    }

    public void presentDictionaries(List<ProvidedDictionaryDetails> providedDictionaries) {
        LOGGER.info(() -> "Received dictionaries: " + String.valueOf(providedDictionaries));
        List<DictionaryViewModel> presentedDictionaries = providedDictionaries.stream().map(GuiDictionaryPresenter::dictionaryViewModelFrom).toList();
        if (!presentedDictionaries.isEmpty()) {
            presentedDictionaries.get(0).select();
        }
        Platform.runLater(() -> this.dictionariesViewModel.dictionariesProperty().setAll((Collection)presentedDictionaries));
    }

    public void presentDictionaryEntries(DictionaryContent content) {
        LOGGER.info(() -> "Received entries of dictionary " + String.valueOf(content.details()) + ": " + content.words().size() + " words");
        Platform.runLater(() -> this.dictionariesViewModel.addWords(GuiDictionaryPresenter.dictionaryKeyFrom(content.details()), (Collection)content.words()));
    }

    public void presentDictionarySearchResult(DictionarySearchResult searchResult) {
        throw new UnsupportedOperationException("Not used");
    }

    public void presentDefaultDictionary(ProvidedDictionaryDetails defaultDictionary) {
        throw new UnsupportedOperationException("Not used");
    }

    public void presentDictionaryError(String error) {
        LOGGER.warning(() -> "Received dictionary error: " + error);
        Platform.runLater(() -> this.errorsViewModel.addError(error));
    }

    private static DictionaryViewModel dictionaryViewModelFrom(ProvidedDictionaryDetails details) {
        return new DictionaryViewModel(details.providerName(), details.dictionaryName(), details.dictionaryLocale(), details.dictionaryDescription());
    }

    private static DictionaryKey dictionaryKeyFrom(ProvidedDictionaryDetails details) {
        return new DictionaryKey(details.providerName(), details.dictionaryName(), details.dictionaryLocale());
    }
}

