/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.aff;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.Aff;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixClass;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixClassHeader;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixRule;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.ThreePartsCompoundFlags;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.AffixClassBuilder;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.ThreePartsCompoundFlagsBuilder;
import re.belv.croiseur.dictionary.hunspell.codec.parser.common.FlagType;
import re.belv.croiseur.dictionary.hunspell.codec.parser.common.ParserException;

final class AffBuilder {
    private final Map<Flag, AffixClassBuilder> affixClassBuilders = new HashMap<Flag, AffixClassBuilder>();
    private Charset encoding = StandardCharsets.US_ASCII;
    private FlagType flagType = FlagType.SINGLE_ASCII;
    private Flag compoundFlag;
    private ThreePartsCompoundFlagsBuilder threePartsCompoundFlagsBuilder = new ThreePartsCompoundFlagsBuilder();

    AffBuilder() {
    }

    AffBuilder addAffixClassHeader(AffixClassHeader affixClassHeader) {
        this.affixClassBuilder(affixClassHeader.flag()).addHeader(affixClassHeader);
        return this;
    }

    AffBuilder setFlagType(FlagType aFlagType) {
        this.flagType = aFlagType;
        return this;
    }

    AffBuilder addAffixRule(AffixRule affixRule) {
        this.affixClassBuilder(affixRule.flag()).addRule(affixRule);
        return this;
    }

    AffBuilder setCompoundFlag(Flag compoundFlagArg) {
        this.compoundFlag = compoundFlagArg;
        return this;
    }

    AffBuilder setCompoundBeginFlag(Flag compoundBeginFlag) {
        this.threePartsCompoundFlagsBuilder.setBeginFlag(compoundBeginFlag);
        return this;
    }

    AffBuilder setCompoundMiddleFlag(Flag compoundMiddleFlag) {
        this.threePartsCompoundFlagsBuilder.setMiddleFlag(compoundMiddleFlag);
        return this;
    }

    AffBuilder setCompoundEndFlag(Flag compoundEndFlag) {
        this.threePartsCompoundFlagsBuilder.setEndFlag(compoundEndFlag);
        return this;
    }

    AffBuilder setEncoding(Charset encodingArg) {
        this.encoding = encodingArg;
        return this;
    }

    Aff build() throws ParserException {
        ArrayList<AffixClass> affixClasses = new ArrayList<AffixClass>();
        for (AffixClassBuilder affixClassBuilder : this.affixClassBuilders.values()) {
            affixClasses.add(affixClassBuilder.build());
        }
        Optional<Flag> optCompoundFlag = Optional.ofNullable(this.compoundFlag);
        Optional<ThreePartsCompoundFlags> optThreePartsCompoundFlags = this.threePartsCompoundFlagsBuilder.build();
        return new Aff(this.encoding, this.flagType, affixClasses, optCompoundFlag, optThreePartsCompoundFlags);
    }

    FlagType flagType() {
        return this.flagType;
    }

    private AffixClassBuilder affixClassBuilder(Flag affixName) {
        return this.affixClassBuilders.computeIfAbsent(affixName, name -> new AffixClassBuilder());
    }
}

