/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.aff;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixClassHeader;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixKind;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;

final class AffixClassHeaderParser {
    private static final Pattern PATTERN = Pattern.compile("^(?<kind>(PFX|SFX)) +(?<flag>[^ /]+) +(?<crossProduct>[YN]) +(?<numberOfRules>[0-9]+)$");

    private AffixClassHeaderParser() {
    }

    static AffixClassHeader parse(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not an affix header: " + line);
        }
        AffixKind kind = AffixKind.valueOf(matcher.group("kind"));
        Flag flag = new Flag(matcher.group("flag"));
        boolean crossProduct = "Y".equals(matcher.group("crossProduct"));
        int numberOfRules = Integer.parseInt(matcher.group("numberOfRules"));
        return new AffixClassHeader(kind, flag, crossProduct, numberOfRules);
    }
}

