/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.dic;

import java.util.Iterator;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.Dic;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.DicEntry;
import re.belv.croiseur.dictionary.hunspell.codec.parser.common.FlagType;
import re.belv.croiseur.dictionary.hunspell.codec.parser.common.ParserException;
import re.belv.croiseur.dictionary.hunspell.codec.parser.dic.DicBuilder;
import re.belv.croiseur.dictionary.hunspell.codec.parser.dic.DicEntryParser;
import re.belv.croiseur.dictionary.hunspell.codec.parser.dic.InvalidDicEntryException;
import re.belv.croiseur.dictionary.hunspell.codec.parser.dic.MissingEstimatedNumberOfEntriesException;

public final class DicParser {
    private static final Pattern NUMBER_OF_ENTRIES = Pattern.compile("^[0-9]+$");
    private static final Pattern COMMENT = Pattern.compile("^[/#].*$");
    private final FlagType flagType;

    public DicParser(FlagType aFlagType) {
        this.flagType = aFlagType;
    }

    private static int readEstimatedNumberOfEntries(Iterator<String> lines) throws MissingEstimatedNumberOfEntriesException {
        if (!lines.hasNext()) {
            throw new MissingEstimatedNumberOfEntriesException();
        }
        String firstLine = lines.next();
        if (!NUMBER_OF_ENTRIES.matcher(firstLine).matches()) {
            throw new MissingEstimatedNumberOfEntriesException(firstLine);
        }
        return Integer.parseInt(firstLine);
    }

    private static boolean isCommented(String line) {
        return COMMENT.matcher(line).matches();
    }

    public Dic parse(Iterator<String> lines) throws ParserException {
        int estimatedNumberOfEntries = DicParser.readEstimatedNumberOfEntries(lines);
        return this.readEntries(estimatedNumberOfEntries, lines);
    }

    private Dic readEntries(int estimatedNumberOfEntries, Iterator<String> lines) throws InvalidDicEntryException {
        DicBuilder builder = new DicBuilder(estimatedNumberOfEntries);
        while (lines.hasNext()) {
            String line = lines.next();
            if (DicParser.isCommented(line) || line.isBlank()) continue;
            DicEntry dicEntry = DicEntryParser.parse(line, this.flagType);
            builder.add(dicEntry);
        }
        return builder.build();
    }
}

