/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.wordforms;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.ThreePartsCompoundFlags;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.DicEntry;
import re.belv.croiseur.dictionary.hunspell.codec.util.MoreCollections;
import re.belv.croiseur.dictionary.hunspell.codec.util.Triplet;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.Affixer;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.BeginMiddleEndCompound;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.Compounder;

final class BeginMiddleEndCompounder
implements Compounder {
    private final Flag beginFlag;
    private final Flag middleFlag;
    private final Flag endFlag;
    private final Affixer affixer;

    BeginMiddleEndCompounder(ThreePartsCompoundFlags flags, Affixer affixerArg) {
        this.beginFlag = flags.begin();
        this.middleFlag = flags.middle();
        this.endFlag = flags.end();
        this.affixer = affixerArg;
    }

    @Override
    public Stream<String> apply(Collection<DicEntry> dicEntries) {
        Map<Flag, Set<DicEntry>> compoundableEntries = this.groupCompoundableEntries(dicEntries);
        Set<DicEntry> beginnings = compoundableEntries.get(this.beginFlag);
        Set<DicEntry> middles = compoundableEntries.get(this.middleFlag);
        Set<DicEntry> ends = compoundableEntries.get(this.endFlag);
        return MoreCollections.triplets(beginnings, middles, ends).stream().mapMulti((compoundParts, accumulator) -> {
            BeginMiddleEndCompound compound = this.compound((Triplet<DicEntry, DicEntry, DicEntry>)compoundParts, (Consumer<String>)accumulator);
            this.applyAffixes(compound, (Consumer<String>)accumulator);
        });
    }

    private Map<Flag, Set<DicEntry>> groupCompoundableEntries(Collection<DicEntry> dicEntries) {
        Map<Flag, Set<DicEntry>> compoundableParts = Map.of(this.beginFlag, new HashSet(), this.middleFlag, new HashSet(), this.endFlag, new HashSet());
        for (DicEntry dicEntry : dicEntries) {
            if (dicEntry.isFlaggedWith(this.beginFlag)) {
                compoundableParts.get(this.beginFlag).add(dicEntry);
            }
            if (dicEntry.isFlaggedWith(this.middleFlag)) {
                compoundableParts.get(this.middleFlag).add(dicEntry);
            }
            if (!dicEntry.isFlaggedWith(this.endFlag)) continue;
            compoundableParts.get(this.endFlag).add(dicEntry);
        }
        return compoundableParts;
    }

    private BeginMiddleEndCompound compound(Triplet<DicEntry, DicEntry, DicEntry> compoundParts, Consumer<String> accumulator) {
        BeginMiddleEndCompound compound = new BeginMiddleEndCompound(compoundParts.left(), compoundParts.middle(), compoundParts.right());
        accumulator.accept(compound.word());
        return compound;
    }

    private void applyAffixes(BeginMiddleEndCompound compound, Consumer<String> accumulator) {
        this.affixer.apply(compound).forEach(accumulator);
    }
}

