/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.wordforms;

import java.util.Optional;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixRule;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.AffixRuleApplicator;

final class PrefixRuleApplicator
implements AffixRuleApplicator {
    private final AffixRule rule;
    private final Optional<Pattern> conditionPattern;
    private final Optional<Pattern> strippingPattern;

    PrefixRuleApplicator(AffixRule aRule) {
        this.rule = PrefixRuleApplicator.validate(aRule);
        this.conditionPattern = PrefixRuleApplicator.compileConditionPattern(aRule);
        this.strippingPattern = PrefixRuleApplicator.compileStrippingPattern(aRule);
    }

    private static Optional<Pattern> compileConditionPattern(AffixRule rule) {
        return rule.condition().map(condition -> Pattern.compile("^" + condition));
    }

    private static Optional<Pattern> compileStrippingPattern(AffixRule rule) {
        return rule.strippingCharacters().map(stripped -> Pattern.compile("^" + stripped));
    }

    private static AffixRule validate(AffixRule rule) {
        if (!rule.isPrefix()) {
            throw new IllegalArgumentException(String.valueOf(rule) + " is not a prefix");
        }
        return rule;
    }

    @Override
    public Optional<String> apply(String stem) {
        return this.isApplicable(stem) ? Optional.of(this.rule.affix() + this.strip(stem)) : Optional.empty();
    }

    private boolean isApplicable(String stem) {
        return this.conditionPattern.map(p -> p.matcher(stem).find()).orElse(true);
    }

    private String strip(String stem) {
        return this.strippingPattern.map(p -> p.matcher(stem).replaceFirst("")).orElse(stem);
    }
}

