/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Logger;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.solver.ginsberg.Dictionary;
import re.belv.croiseur.solver.ginsberg.ProgressListener;
import re.belv.croiseur.solver.ginsberg.SolverResult;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.core.sap.Backtracker;
import re.belv.croiseur.solver.ginsberg.core.sap.CandidateChooser;
import re.belv.croiseur.solver.ginsberg.core.sap.Solver;
import re.belv.croiseur.solver.ginsberg.dictionary.CachedDictionaryWriter;
import re.belv.croiseur.solver.ginsberg.heuristics.backtrack.Backtrackers;
import re.belv.croiseur.solver.ginsberg.heuristics.instantiation.CandidateChoosers;
import re.belv.croiseur.solver.ginsberg.heuristics.iteration.SlotIteratorImpl;
import re.belv.croiseur.solver.ginsberg.listener.FineProgressPrinter;
import re.belv.croiseur.solver.ginsberg.listener.ProgressNotifier;
import re.belv.croiseur.solver.ginsberg.listener.StatisticsRecorder;
import re.belv.croiseur.solver.ginsberg.result.SolverResultFactory;
import re.belv.croiseur.solver.ginsberg.state.Crossword;
import re.belv.croiseur.solver.ginsberg.state.CrosswordUpdater;

public final class GinsbergCrosswordSolver {
    private static final Logger LOGGER = Logger.getLogger(GinsbergCrosswordSolver.class.getName());

    private static Solver newSolver(Crossword problem, ProgressListener progressListener, StatisticsRecorder statisticsRecorder) {
        Collection<Slot> slots = problem.grid().puzzle().slots();
        SlotIteratorImpl slotChooser = new SlotIteratorImpl(slots, problem.dictionary());
        CandidateChooser<Slot, String> candidateChooser = CandidateChoosers.byDefault(problem.probePuzzle(), problem.dictionary());
        Backtracker<Slot, SlotIdentifier> backtracker = Backtrackers.byDefault(problem.grid().puzzle(), problem.probePuzzle(), problem.history());
        ProgressNotifier progressNotifier = new ProgressNotifier(slots, progressListener);
        FineProgressPrinter fineProgressPrinter = new FineProgressPrinter(problem.grid());
        CrosswordUpdater crosswordUpdater = new CrosswordUpdater(problem).withListeners(progressNotifier, statisticsRecorder, fineProgressPrinter);
        return Solver.create(crosswordUpdater, slotChooser, candidateChooser, backtracker);
    }

    private static void printPuzzleInsights(Crossword crossword) {
        CachedDictionaryWriter dictionary = crossword.dictionary();
        Collection<Slot> slots = crossword.grid().puzzle().slots();
        BigInteger branches = slots.stream().map(s -> BigInteger.valueOf(dictionary.cachedCandidatesCount((Slot)s))).reduce(BigInteger.ONE, BigInteger::multiply);
        DecimalFormat formatter = new DecimalFormat("0.######E0", DecimalFormatSymbols.getInstance(Locale.ROOT));
        LOGGER.info(() -> "Total branches (slot variables, pre-pruned): " + formatter.format(branches));
    }

    public SolverResult solve(PuzzleGrid puzzleGrid, Dictionary externalDictionary, ProgressListener progressListener) throws InterruptedException {
        progressListener.onInitialisationStart();
        Crossword crossword = Crossword.create(puzzleGrid, externalDictionary);
        StatisticsRecorder stats = new StatisticsRecorder();
        Solver solver = GinsbergCrosswordSolver.newSolver(crossword, progressListener, stats);
        GinsbergCrosswordSolver.printPuzzleInsights(crossword);
        progressListener.onInitialisationEnd();
        boolean solved = solver.solve();
        progressListener.onSolverProgressUpdate((short)100);
        return SolverResultFactory.createFrom(crossword, stats, solved);
    }

    public SolverResult solve(PuzzleGrid puzzle, Dictionary dictionary) throws InterruptedException {
        return this.solve(puzzle, dictionary, ProgressListener.DUMMY_LISTENER);
    }
}

