/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.core.sap;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import re.belv.croiseur.solver.ginsberg.core.sap.Backtracker;
import re.belv.croiseur.solver.ginsberg.core.sap.CandidateChooser;
import re.belv.croiseur.solver.ginsberg.core.sap.Elimination;
import re.belv.croiseur.solver.ginsberg.core.sap.ProblemStateUpdater;
import re.belv.croiseur.solver.ginsberg.core.sap.Solver;

final class SolverImpl<VariableT, ValueT, EliminationReasonT>
implements Solver {
    private final ProblemStateUpdater<VariableT, ValueT, EliminationReasonT> problem;
    private final Iterator<VariableT> variableIterator;
    private final CandidateChooser<VariableT, ValueT> candidateChooser;
    private final Backtracker<VariableT, EliminationReasonT> backtracker;

    SolverImpl(ProblemStateUpdater<VariableT, ValueT, EliminationReasonT> aProblem, Iterator<VariableT> aVariableIterator, CandidateChooser<VariableT, ValueT> aCandidateChooser, Backtracker<VariableT, EliminationReasonT> aBacktracker) {
        this.problem = Objects.requireNonNull(aProblem);
        this.variableIterator = Objects.requireNonNull(aVariableIterator);
        this.candidateChooser = Objects.requireNonNull(aCandidateChooser);
        this.backtracker = Objects.requireNonNull(aBacktracker);
    }

    @Override
    public boolean solve() throws InterruptedException {
        boolean hasSolution = true;
        while (!Thread.currentThread().isInterrupted() && this.variableIterator.hasNext() && hasSolution) {
            VariableT variable = this.variableIterator.next();
            Optional<ValueT> candidate = this.candidateChooser.find(variable);
            if (candidate.isPresent()) {
                this.problem.assign(variable, candidate.get());
                continue;
            }
            List<Elimination<VariableT, EliminationReasonT>> toUnassign = this.backtracker.backtrackFrom(variable);
            if (toUnassign.isEmpty()) {
                hasSolution = false;
                continue;
            }
            toUnassign.forEach(this.problem::unassign);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Solver interrupted");
        }
        return hasSolution;
    }
}

