/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.dictionary;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class Trie
extends AbstractSet<String> {
    private final TrieNode root = new TrieNode();
    private int size;

    Trie(Collection<String> words) {
        for (String word : words) {
            boolean added = Trie.insertBelow(this.root, word);
            if (!added) continue;
            ++this.size;
        }
    }

    Trie() {
        this(Collections.emptySet());
    }

    private static boolean insertBelow(TrieNode root, String word) {
        TrieNode current = root;
        for (int i = 0; i < word.length(); ++i) {
            char character = word.charAt(i);
            current = current.children.computeIfAbsent(Character.valueOf(character), key -> new TrieNode());
        }
        boolean added = !current.isTerminal;
        current.isTerminal = true;
        return added;
    }

    @Override
    public boolean add(String word) {
        boolean added = Trie.insertBelow(this.root, word);
        if (added) {
            ++this.size;
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed;
        if (!(o instanceof String)) {
            removed = false;
        } else {
            String word = (String)o;
            TrieIterator it = new TrieIterator(this, new PositivePatternMatcher(word));
            if (it.hasNext()) {
                it.next();
                it.remove();
                removed = true;
            } else {
                removed = false;
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        this.root.children.clear();
        this.size = 0;
    }

    @Override
    public boolean contains(Object object) {
        boolean result;
        if (!(object instanceof String)) {
            result = false;
        } else {
            String word = (String)object;
            TrieNode current = this.root;
            for (int i = 0; i < word.length() && current != null; ++i) {
                char character = word.charAt(i);
                current = current.children.get(Character.valueOf(character));
            }
            result = current != null && current.isTerminal;
        }
        return result;
    }

    @Override
    public Iterator<String> iterator() {
        return new TrieIterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    boolean containsMatching(String pattern) {
        return new TrieIterator(this, new PositivePatternMatcher(pattern)).hasNext();
    }

    boolean removeNonMatching(String pattern) {
        TrieIterator it = new TrieIterator(this, new NegativePatternMatcher(pattern));
        boolean removed = false;
        while (it.hasNext()) {
            it.next();
            it.remove();
            removed = true;
        }
        return removed;
    }

    Stream<String> streamMatching(String pattern) {
        TrieIterator iterator = new TrieIterator(this, new PositivePatternMatcher(pattern));
        Spliterator<String> splitIterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return StreamSupport.stream(splitIterator, false);
    }

    private static final class TrieNode {
        private final Map<Character, TrieNode> children = new LinkedHashMap<Character, TrieNode>();
        private boolean isTerminal;

        private TrieNode() {
        }
    }

    private final class TrieIterator
    implements Iterator<String> {
        private final ListIterator<Iterator<Map.Entry<Character, TrieNode>>> nodeIterators;
        private final PatternMatcher patternMatcher;
        private final StringBuilder nextWordBuilder;
        private String nextWord;
        private TrieNode next;
        private TrieNode current;
        final /* synthetic */ Trie this$0;

        TrieIterator(Trie trie, PatternMatcher patternMatcherArg) {
            Trie trie2 = trie;
            Objects.requireNonNull(trie2);
            this.this$0 = trie2;
            this.patternMatcher = patternMatcherArg;
            this.nextWordBuilder = new StringBuilder();
            this.nodeIterators = new ArrayList().listIterator();
            this.nodeIterators.add(this.patternMatcher.nextLetterMatches(trie.root, 0));
            this.findAndUpdateNextWord();
        }

        TrieIterator(Trie trie) {
            this(trie, NoPatternMatcher.INSTANCE);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.isTerminal = false;
            --this.this$0.size;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextWord != null;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            String currentWord = this.nextWord;
            this.findAndUpdateNextWord();
            return currentWord;
        }

        private void findAndUpdateNextWord() {
            boolean foundWord = this.descendToNextWord();
            while (!foundWord && this.ascendToNextPrefix()) {
                foundWord = this.descendToNextWord();
            }
            this.nextWord = foundWord ? this.nextWordBuilder.toString() : null;
        }

        private boolean descendToNextWord() {
            boolean foundWord = false;
            while (this.nodeIterators.hasNext() && !foundWord) {
                Iterator<Map.Entry<Character, TrieNode>> nodeIt = this.nodeIterators.next();
                if (nodeIt.hasNext()) {
                    Map.Entry<Character, TrieNode> nodeEntry = nodeIt.next();
                    char nodeChar = nodeEntry.getKey().charValue();
                    this.nextWordBuilder.append(nodeChar);
                    TrieNode node = nodeEntry.getValue();
                    this.nodeIterators.add(this.patternMatcher.nextLetterMatches(node, this.nodeIterators.nextIndex()));
                    this.nodeIterators.previous();
                    foundWord = this.isMatchingTerminalNode(node);
                    if (!foundWord) continue;
                    this.next = node;
                    continue;
                }
                this.nodeIterators.remove();
            }
            return foundWord;
        }

        private boolean ascendToNextPrefix() {
            boolean foundPrefix = false;
            while (this.nodeIterators.hasPrevious() && !foundPrefix) {
                Iterator<Map.Entry<Character, TrieNode>> previousNodeIt = this.nodeIterators.previous();
                if (previousNodeIt.hasNext()) {
                    foundPrefix = true;
                    this.nextWordBuilder.delete(this.nodeIterators.nextIndex(), this.nextWordBuilder.length());
                    continue;
                }
                this.nodeIterators.remove();
            }
            return foundPrefix;
        }

        private boolean isMatchingTerminalNode(TrieNode node) {
            return node.isTerminal && this.patternMatcher.matches(this.nextWordBuilder);
        }
    }

    private static final class PositivePatternMatcher
    implements PatternMatcher {
        private final String pattern;

        PositivePatternMatcher(String patternArg) {
            this.pattern = Objects.requireNonNull(patternArg);
        }

        @Override
        public Iterator<Map.Entry<Character, TrieNode>> nextLetterMatches(TrieNode node, int position) {
            TrieNode exactLetterNode;
            char patternLetter;
            Iterator<Map.Entry<Character, TrieNode>> nextLetterMatches = position >= this.pattern.length() ? Collections.emptyIterator() : ((patternLetter = this.pattern.charAt(position)) == ' ' ? node.children.entrySet().iterator() : ((exactLetterNode = node.children.get(Character.valueOf(patternLetter))) != null ? Collections.singletonMap(Character.valueOf(patternLetter), exactLetterNode).entrySet().iterator() : Collections.emptyIterator()));
            return nextLetterMatches;
        }

        @Override
        public boolean matches(CharSequence word) {
            return this.pattern.length() == word.length();
        }
    }

    private static interface PatternMatcher {
        public static final char ANY_CHARACTER_WILDCARD = ' ';

        public Iterator<Map.Entry<Character, TrieNode>> nextLetterMatches(TrieNode var1, int var2);

        public boolean matches(CharSequence var1);
    }

    private static final class NegativePatternMatcher
    implements PatternMatcher {
        private final String pattern;

        NegativePatternMatcher(String patternArg) {
            this.pattern = Objects.requireNonNull(patternArg);
        }

        @Override
        public Iterator<Map.Entry<Character, TrieNode>> nextLetterMatches(TrieNode node, int position) {
            return node.children.entrySet().iterator();
        }

        @Override
        public boolean matches(CharSequence word) {
            if (this.pattern.length() != word.length()) {
                return true;
            }
            for (int i = 0; i < this.pattern.length(); ++i) {
                char pi = this.pattern.charAt(i);
                if (pi == ' ' || pi == word.charAt(i)) continue;
                return true;
            }
            return false;
        }
    }

    private static enum NoPatternMatcher implements PatternMatcher
    {
        INSTANCE;


        @Override
        public Iterator<Map.Entry<Character, TrieNode>> nextLetterMatches(TrieNode node, int position) {
            return node.children.entrySet().iterator();
        }

        @Override
        public boolean matches(CharSequence word) {
            return true;
        }
    }
}

