/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.elimination;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.elimination.EliminationSpaceWriter;

final class EliminationSpaceImpl
implements EliminationSpaceWriter {
    private final Map<SlotIdentifier, Map<String, Set<SlotIdentifier>>> eliminations = new HashMap<SlotIdentifier, Map<String, Set<SlotIdentifier>>>();

    EliminationSpaceImpl() {
    }

    @Override
    public Set<String> eliminatedValues(SlotIdentifier slot) {
        return Collections.unmodifiableSet(this.initialisedEliminations(slot).keySet());
    }

    @Override
    public Map<String, Set<SlotIdentifier>> eliminations(SlotIdentifier slot) {
        return Collections.unmodifiableMap(this.initialisedEliminations(slot));
    }

    @Override
    public void eliminate(SlotIdentifier unassigned, Collection<SlotIdentifier> reasons, String eliminated) {
        this.eliminationReasons(unassigned, eliminated).addAll(reasons);
        for (Map<String, Set<SlotIdentifier>> entry : this.eliminations.values()) {
            Iterator<Map.Entry<String, Set<SlotIdentifier>>> it = entry.entrySet().iterator();
            while (it.hasNext()) {
                Set<SlotIdentifier> previousReasons = it.next().getValue();
                if (!previousReasons.contains(unassigned)) continue;
                it.remove();
            }
        }
    }

    private Map<String, Set<SlotIdentifier>> initialisedEliminations(SlotIdentifier slot) {
        return this.eliminations.computeIfAbsent(slot, k -> new HashMap());
    }

    private Set<SlotIdentifier> eliminationReasons(SlotIdentifier slot, String eliminatedValue) {
        return this.initialisedEliminations(slot).computeIfAbsent(eliminatedValue, k -> new HashSet());
    }

    public String toString() {
        return this.eliminations.toString();
    }
}

