/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.grid;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.grid.BoxData;
import re.belv.croiseur.solver.ginsberg.grid.SlotData;

final class GridData {
    private final BoxData[][] grid;
    private final Map<SlotIdentifier, SlotData> slots;
    private final Map<SlotIdentifier, Set<SlotIdentifier>> connections;

    GridData(BoxData[][] aGrid, Map<SlotIdentifier, SlotData> someSlots) {
        this.grid = aGrid;
        this.slots = someSlots;
        this.connections = new HashMap<SlotIdentifier, Set<SlotIdentifier>>();
        for (Map.Entry<SlotIdentifier, SlotData> oneSlot : someSlots.entrySet()) {
            LinkedHashSet<SlotIdentifier> connectedSlots = new LinkedHashSet<SlotIdentifier>();
            for (Map.Entry<SlotIdentifier, SlotData> anotherSlot : someSlots.entrySet()) {
                if (!oneSlot.getValue().definition().isConnected(anotherSlot.getValue().definition())) continue;
                connectedSlots.add(anotherSlot.getKey());
            }
            this.connections.put(oneSlot.getKey(), Collections.unmodifiableSet(connectedSlots));
        }
    }

    private GridData(GridData other) {
        this.grid = new BoxData[other.grid.length][other.grid[0].length];
        for (int y = 0; y < other.grid.length; ++y) {
            for (int x = 0; x < other.grid[0].length; ++x) {
                this.grid[y][x] = other.grid[y][x].copy();
            }
        }
        this.slots = new HashMap<SlotIdentifier, SlotData>(other.slots.size());
        for (Map.Entry<SlotIdentifier, SlotData> slotEntry : other.slots.entrySet()) {
            SlotIdentifier slotIdentifier = slotEntry.getKey();
            SlotData data = slotEntry.getValue();
            this.slots.put(slotIdentifier, new SlotData(data.definition(), this.grid, data.isInstantiated()));
        }
        this.connections = other.connections;
    }

    GridData copy() {
        return new GridData(this);
    }

    SlotData slot(SlotIdentifier slotId) {
        return this.slots.get(slotId);
    }

    Map<SlotIdentifier, SlotData> slots() {
        return Collections.unmodifiableMap(this.slots);
    }

    Set<SlotIdentifier> connectedSlots(SlotIdentifier slotId) {
        return this.connections.get(slotId);
    }

    Map<GridPosition, Character> toBoxes() {
        HashMap<GridPosition, Character> result = new HashMap<GridPosition, Character>();
        for (int y = 0; y < this.grid.length; ++y) {
            BoxData[] row = this.grid[y];
            for (int x = 0; x < row.length; ++x) {
                BoxData box = row[x];
                if (box.isEmpty()) continue;
                result.put(new GridPosition(x, y), Character.valueOf(box.value()));
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        for (BoxData[] row : this.grid) {
            sb.append('|');
            for (BoxData box : row) {
                sb.append(box.toString());
                sb.append('|');
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }
}

