/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.grid;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.grid.BoxData;
import re.belv.croiseur.solver.ginsberg.grid.Boxes;
import re.belv.croiseur.solver.ginsberg.grid.GridData;
import re.belv.croiseur.solver.ginsberg.grid.SlotData;
import re.belv.croiseur.solver.ginsberg.grid.SlotDefinition;

final class GridDataBuilder {
    private final Set<GridPosition> shaded = new HashSet<GridPosition>();
    private final Map<GridPosition, Character> prefilled = new HashMap<GridPosition, Character>();
    private int height;
    private int width;

    GridDataBuilder() {
    }

    static GridDataBuilder from(PuzzleGrid puzzle) {
        GridDataBuilder builder = new GridDataBuilder();
        builder.width = puzzle.width();
        builder.height = puzzle.height();
        builder.shaded.addAll(puzzle.shaded());
        builder.prefilled.putAll(puzzle.filled());
        return builder;
    }

    GridDataBuilder withHeight(int anHeight) {
        this.height = anHeight;
        return this;
    }

    GridDataBuilder withWidth(int aWidth) {
        this.width = aWidth;
        return this;
    }

    GridDataBuilder withShaded(GridPosition gridPosition) {
        this.shaded.add(gridPosition);
        return this;
    }

    GridData build() {
        this.validate();
        BoxData[][] grid = this.buildGrid();
        return new GridData(grid, this.buildSlots(grid));
    }

    private Map<SlotIdentifier, SlotData> buildSlots(BoxData[][] grid) {
        HashMap<SlotIdentifier, SlotData> slots = new HashMap<SlotIdentifier, SlotData>();
        int id = 1;
        for (int x = 0; x < this.width; ++x) {
            int yStart = 0;
            int yEnd = this.nextShadedOnColumn(x, 0);
            while (yStart < this.height) {
                if (yEnd - yStart > 1) {
                    slots.put(new SlotIdentifier(id), new SlotData(new SlotDefinition(x, yStart, yEnd, SlotDefinition.Type.VERTICAL), grid));
                }
                yStart = this.nextVerticalSlot(x, yEnd);
                yEnd = this.nextShadedOnColumn(x, yStart);
                ++id;
            }
        }
        for (int y = 0; y < this.height; ++y) {
            int xStart = 0;
            int xEnd = this.nextShadedOnLine(y, 0);
            while (xStart < this.width) {
                if (xEnd - xStart > 1) {
                    slots.put(new SlotIdentifier(id), new SlotData(new SlotDefinition(y, xStart, xEnd, SlotDefinition.Type.HORIZONTAL), grid));
                }
                xStart = this.nextHorizontalSlot(y, xEnd);
                xEnd = this.nextShadedOnLine(y, xStart);
                ++id;
            }
        }
        return slots;
    }

    private int nextShadedOnLine(int y, int xStart) {
        for (int x = xStart; x < this.width; ++x) {
            if (!this.shaded.contains(new GridPosition(x, y))) continue;
            return x;
        }
        return this.width;
    }

    private int nextShadedOnColumn(int x, int yStart) {
        for (int y = yStart; y < this.height; ++y) {
            if (!this.shaded.contains(new GridPosition(x, y))) continue;
            return y;
        }
        return this.height;
    }

    private int nextVerticalSlot(int x, int yStart) {
        for (int y = yStart; y < this.height; ++y) {
            if (this.shaded.contains(new GridPosition(x, y))) continue;
            return y;
        }
        return this.height;
    }

    private int nextHorizontalSlot(int y, int xStart) {
        for (int x = xStart; x < this.width; ++x) {
            if (this.shaded.contains(new GridPosition(x, y))) continue;
            return x;
        }
        return this.width;
    }

    private BoxData[][] buildGrid() {
        BoxData[][] result = new BoxData[this.height][this.width];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                GridPosition coord = new GridPosition(x, y);
                result[y][x] = this.shaded.contains(coord) ? Boxes.shaded() : (this.prefilled.containsKey(coord) ? Boxes.prefilled(this.prefilled.get(coord).charValue()) : Boxes.computed());
            }
        }
        return result;
    }

    private void validate() {
        if (this.width <= 0 || this.height <= 0) {
            throw new IllegalArgumentException("Invalid dimensions");
        }
        if (this.shaded.stream().anyMatch(s -> s.x() < 0 || s.x() >= this.width || s.y() < 0 || s.y() >= this.height)) {
            throw new IllegalArgumentException("Invalid shaded definitions");
        }
    }
}

