/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.grid;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import re.belv.croiseur.solver.ginsberg.grid.BoxData;
import re.belv.croiseur.solver.ginsberg.grid.SlotDefinition;

final class SlotData {
    private final BoxData[][] grid;
    private final SlotDefinition definition;
    private boolean instantiated;

    SlotData(SlotDefinition aDefinition, BoxData[][] aGrid) {
        this(aDefinition, aGrid, false);
    }

    SlotData(SlotDefinition aDefinition, BoxData[][] aGrid, boolean anInstantiated) {
        this.definition = aDefinition;
        this.grid = aGrid;
        this.instantiated = anInstantiated;
    }

    public String toString() {
        return "SlotData{definition=" + String.valueOf(this.definition) + ", value=" + String.valueOf(this.value()) + "}";
    }

    int length() {
        return this.definition.length();
    }

    void write(String value) {
        if (value == null || this.definition.length() != value.length()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < value.length(); ++i) {
            this.boxAt(i).set(value.charAt(i));
        }
        this.instantiated = true;
    }

    void clearExcept(Set<Integer> boxesToKeep) {
        for (int i = 0; i < this.definition.length(); ++i) {
            if (boxesToKeep.contains(i)) continue;
            this.boxAt(i).reset();
        }
        this.instantiated = false;
    }

    void clear() {
        this.clearExcept(Collections.emptySet());
    }

    SlotDefinition definition() {
        return this.definition;
    }

    Optional<String> value() {
        if (!this.instantiated) {
            return Optional.empty();
        }
        char[] readValue = new char[this.definition.length()];
        for (int i = 0; i < this.definition.length(); ++i) {
            BoxData box = this.boxAt(i);
            if (box.isEmpty()) {
                throw new IllegalStateException("Detected blank in an assigned word, check your dictionary");
            }
            readValue[i] = box.value();
        }
        return Optional.of(String.valueOf(readValue));
    }

    boolean isInstantiated() {
        return this.instantiated;
    }

    int emptyBoxRatio() {
        int empty = 0;
        for (int i = 0; i < this.length(); ++i) {
            if (!this.boxAt(i).isEmpty()) continue;
            ++empty;
        }
        return empty * 100 / this.length();
    }

    BoxData boxAt(int i) {
        BoxData box = this.definition.type().isHorizontal() ? this.grid[this.definition.offset()][this.definition.start() + i] : this.grid[this.definition.start() + i][this.definition.offset()];
        return box;
    }
}

