/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.heuristics.backtrack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.core.sap.Backtracker;
import re.belv.croiseur.solver.ginsberg.core.sap.Elimination;
import re.belv.croiseur.solver.ginsberg.grid.Puzzle;
import re.belv.croiseur.solver.ginsberg.history.History;
import re.belv.croiseur.solver.ginsberg.lookahead.ProbePuzzle;
import re.belv.croiseur.solver.ginsberg.lookahead.Unassignment;

final class DynamicBacktracker
implements Backtracker<Slot, SlotIdentifier> {
    private static final Logger LOGGER = Logger.getLogger(DynamicBacktracker.class.getName());
    private final Puzzle puzzle;
    private final History history;
    private final ProbePuzzle probePuzzle;

    DynamicBacktracker(Puzzle puzzleArg, ProbePuzzle probePuzzleArg, History historyArg) {
        this.probePuzzle = probePuzzleArg;
        this.puzzle = puzzleArg;
        this.history = historyArg;
    }

    @Override
    public List<Elimination<Slot, SlotIdentifier>> backtrackFrom(Slot variable) {
        LOGGER.fine(() -> String.valueOf(variable) + " is not assignable, looking for a backtrack point");
        Set<SlotIdentifier> candidates = this.candidatesFrom(variable);
        List<SlotIdentifier> chosen = this.choose(candidates, variable);
        List<Elimination<Slot, SlotIdentifier>> eliminations = this.eliminationsFrom(candidates, chosen);
        LOGGER.fine(() -> "Backtrack gave the following eliminations: " + String.valueOf(eliminations));
        return eliminations;
    }

    private Set<SlotIdentifier> candidatesFrom(Slot unassignable) {
        Stream<SlotIdentifier> directCandidates = unassignable.connectedSlots().filter(Slot::isInstantiated).map(Slot::uid).sorted(Comparator.comparingLong(this.history::assignmentNumber).reversed());
        Stream<SlotIdentifier> indirectCandidates = unassignable.connectedSlots().filter(Predicate.not(Slot::isInstantiated)).flatMap(Slot::connectedSlots).filter(Slot::isInstantiated).map(Slot::uid).sorted(Comparator.comparingLong(this.history::assignmentNumber).reversed());
        return Stream.of(directCandidates, indirectCandidates).flatMap(Function.identity()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    List<SlotIdentifier> choose(Set<SlotIdentifier> candidates, Slot unassignable) {
        List<SlotIdentifier> eliminatedSlots;
        Optional<SlotIdentifier> eliminated = candidates.stream().filter(candidate -> this.probePuzzle.hasSolutionAfter(Unassignment.of(candidate), unassignable)).findFirst();
        if (eliminated.isEmpty()) {
            LOGGER.info("No direct backtracking solves the problem, trying to backjump");
            eliminatedSlots = new ArrayList<SlotIdentifier>();
            Iterator<SlotIdentifier> candidatesLeft = candidates.iterator();
            if (candidatesLeft.hasNext()) {
                eliminatedSlots.add(candidatesLeft.next());
            }
            boolean solutionFound = false;
            while (candidatesLeft.hasNext() && !solutionFound) {
                eliminatedSlots.add(candidatesLeft.next());
                List<Unassignment> unassignments = eliminatedSlots.stream().map(Unassignment::of).toList();
                LOGGER.info(() -> "Trying the following combined unassignments " + String.valueOf(unassignments));
                solutionFound = this.probePuzzle.hasSolutionAfter(unassignments, unassignable);
            }
            if (!solutionFound) {
                eliminatedSlots.clear();
            }
        } else {
            eliminatedSlots = Collections.singletonList(eliminated.get());
        }
        return eliminatedSlots;
    }

    private List<Elimination<Slot, SlotIdentifier>> eliminationsFrom(Set<SlotIdentifier> candidates, List<SlotIdentifier> chosen) {
        List<Elimination<Slot, SlotIdentifier>> eliminations;
        if (!chosen.isEmpty()) {
            Set reasons = candidates.stream().filter(uid -> !chosen.contains(uid)).collect(Collectors.toSet());
            if (reasons.isEmpty()) {
                LOGGER.info("No reason found, adding global reason.");
                reasons.add(new SlotIdentifier(-1));
            }
            eliminations = chosen.stream().map(eliminated -> new Elimination(this.puzzle.slot((SlotIdentifier)eliminated), reasons)).toList();
        } else {
            eliminations = Collections.emptyList();
        }
        return eliminations;
    }
}

