/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.heuristics.instantiation;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.core.sap.CandidateChooser;
import re.belv.croiseur.solver.ginsberg.dictionary.CachedDictionary;
import re.belv.croiseur.solver.ginsberg.lookahead.Assignment;
import re.belv.croiseur.solver.ginsberg.lookahead.ProbePuzzle;

final class LeastConstrainingCandidateChooser
implements CandidateChooser<Slot, String> {
    private static final long MAX_NUMBER_OF_CANDIDATES_TO_COMPARE = 10L;
    private static final Comparator<NumberOfSolutionsPerCandidate> BY_NUMBER_OF_SOLUTIONS = Comparator.comparing(NumberOfSolutionsPerCandidate::numberOfSolutions).thenComparing(NumberOfSolutionsPerCandidate::candidate);
    private static final Predicate<NumberOfSolutionsPerCandidate> WITH_SOLUTION = probe -> probe.numberOfSolutions.signum() > 0;
    private final CachedDictionary dictionary;
    private final ProbePuzzle probePuzzle;

    LeastConstrainingCandidateChooser(ProbePuzzle probePuzzleArg, CachedDictionary dictionaryArg) {
        this.dictionary = dictionaryArg;
        this.probePuzzle = probePuzzleArg;
    }

    @Override
    public Optional<String> find(Slot wordVariable) {
        return this.dictionary.candidates(wordVariable).map(candidate -> this.probe(wordVariable, (String)candidate)).filter(WITH_SOLUTION).limit(10L).max(BY_NUMBER_OF_SOLUTIONS).map(NumberOfSolutionsPerCandidate::candidate);
    }

    private NumberOfSolutionsPerCandidate probe(Slot wordVariable, String candidate) {
        BigInteger numberOfSolutions = this.probePuzzle.computeNumberOfLocalSolutionsAfter(Assignment.of(wordVariable.uid(), candidate));
        return new NumberOfSolutionsPerCandidate(candidate, numberOfSolutions);
    }

    private record NumberOfSolutionsPerCandidate(String candidate, BigInteger numberOfSolutions) {
    }
}

