/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.heuristics.iteration;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.core.sap.VariableIterator;
import re.belv.croiseur.solver.ginsberg.dictionary.CachedDictionary;

public final class SlotIteratorImpl
implements VariableIterator<Slot> {
    private static final Comparator<NumberOfCandidatesPerSlot> BY_OPENNESS = Comparator.comparingLong(NumberOfCandidatesPerSlot::numberOfCandidates).thenComparingInt(pair -> pair.slot.emptyBoxRatio()).thenComparingInt(pair -> pair.slot.uid().id());
    private static final Predicate<Slot> NOT_INSTANTIATED = Predicate.not(Slot::isInstantiated);
    private final CachedDictionary dictionary;
    private final Collection<Slot> variables;

    public SlotIteratorImpl(Collection<Slot> slots, CachedDictionary aDictionary) {
        this.variables = Collections.unmodifiableCollection(slots);
        this.dictionary = aDictionary;
    }

    @Override
    public boolean hasNext() {
        return this.variables.stream().anyMatch(NOT_INSTANTIATED);
    }

    @Override
    public Slot next() {
        return this.variables.stream().filter(NOT_INSTANTIATED).map(slot -> new NumberOfCandidatesPerSlot((Slot)slot, this.dictionary.cachedCandidatesCount((Slot)slot))).min(BY_OPENNESS).map(NumberOfCandidatesPerSlot::slot).orElseThrow(NoSuchElementException::new);
    }

    private record NumberOfCandidatesPerSlot(Slot slot, long numberOfCandidates) {
    }
}

