/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.result;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.solver.ginsberg.SolverResult;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.listener.StatisticsRecorder;
import re.belv.croiseur.solver.ginsberg.result.SolverResultImpl;
import re.belv.croiseur.solver.ginsberg.state.Crossword;

public final class SolverResultFactory {
    private SolverResultFactory() {
    }

    public static SolverResult createFrom(Crossword crossword, StatisticsRecorder statisticsRecorder, boolean success) {
        SolverResultImpl solverResult;
        Map<GridPosition, Character> solvedBoxes = crossword.grid().boxes();
        if (success) {
            solverResult = SolverResultImpl.success(solvedBoxes, statisticsRecorder.statistics());
        } else {
            Set<GridPosition> unsolvableBoxes = crossword.grid().puzzle().slots().stream().filter(slot -> crossword.dictionary().cachedCandidatesCount((Slot)slot) == 0L).flatMap(slot -> crossword.grid().slotPositions((Slot)slot).stream()).collect(Collectors.toSet());
            solverResult = SolverResultImpl.impossible(solvedBoxes, unsolvableBoxes, statisticsRecorder.statistics());
        }
        return solverResult;
    }
}

