/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.StringProperty;
import javafx.collections.ListChangeListener;
import re.belv.croiseur.gui.view.model.DictionaryKey;
import re.belv.croiseur.gui.view.model.DictionaryViewModel;
import re.belv.croiseur.gui.view.model.util.ObservableAggregateList;

public final class DictionariesViewModel {
    private final ListProperty<DictionaryViewModel> dictionaries;
    private final ReadOnlyListWrapper<DictionaryViewModel> selectedDictionaries;
    private final ReadOnlyListWrapper<String> words;
    private final StringProperty suggestionFilter;
    private final ReadOnlyListWrapper<String> suggestions;
    private final Map<DictionaryKey, Integer> dictionaryToWordAggregateIndex;
    private final ObservableAggregateList<String> backingAggregateWordList;

    /*
     * Exception decompiling
     */
    public DictionariesViewModel() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ListProperty<DictionaryViewModel> dictionariesProperty() {
        return this.dictionaries;
    }

    public ReadOnlyListProperty<DictionaryViewModel> selectedDictionariesProperty() {
        return this.selectedDictionaries.getReadOnlyProperty();
    }

    public ReadOnlyListProperty<String> wordsProperty() {
        return this.words.getReadOnlyProperty();
    }

    public StringProperty suggestionFilterProperty() {
        return this.suggestionFilter;
    }

    public ReadOnlyListProperty<String> suggestionsProperty() {
        return this.suggestions.getReadOnlyProperty();
    }

    public void addWords(DictionaryKey key, Collection<String> addedWords) {
        if (this.selectedDictionaries.stream().anyMatch(dictionary -> dictionary.key().equals(key))) {
            int aggregateNumber = this.backingAggregateWordList.aggregateCount();
            this.backingAggregateWordList.aggregate(addedWords);
            this.dictionaryToWordAggregateIndex.put(key, aggregateNumber);
        }
    }

    private Predicate<String> createSuggestionPredicate() {
        Predicate<String> predicate;
        String regex = (String)this.suggestionFilter.get();
        if (regex.isEmpty()) {
            predicate = word -> false;
        } else {
            Matcher matcher = Pattern.compile(regex).matcher("");
            predicate = word -> word.length() == regex.length() && matcher.reset((CharSequence)word).matches();
        }
        return predicate;
    }

    private void onSelectedDictionaryChange(ListChangeListener.Change<? extends DictionaryViewModel> change) {
        while (change.next()) {
            if (!change.wasRemoved()) continue;
            List removedDictionaries = change.getRemoved();
            for (DictionaryViewModel removedDictionaryViewModel : removedDictionaries) {
                Integer removedAggregateIndex = this.dictionaryToWordAggregateIndex.remove(removedDictionaryViewModel.key());
                if (removedAggregateIndex == null) continue;
                this.backingAggregateWordList.disaggregate(removedAggregateIndex);
                this.refreshAggregateIndexes(removedAggregateIndex);
            }
        }
    }

    private void refreshAggregateIndexes(Integer removedAggregateIndex) {
        for (Map.Entry<DictionaryKey, Integer> remainingEntry : this.dictionaryToWordAggregateIndex.entrySet()) {
            Integer remainingAggregateIndex = remainingEntry.getValue();
            if (remainingAggregateIndex <= removedAggregateIndex) continue;
            int newRemainingAggregateIndex = remainingAggregateIndex - 1;
            remainingEntry.setValue(newRemainingAggregateIndex);
        }
    }
}

