/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.PuzzleDetailsViewModel;
import re.belv.croiseur.gui.view.model.SavedPuzzleGridViewModel;

public final class SavedPuzzleViewModel {
    private final PuzzleDetailsViewModel details;
    private final SavedPuzzleGridViewModel grid;

    public SavedPuzzleViewModel(PuzzleDetailsViewModel detailsArg, SavedPuzzleGridViewModel gridArg) {
        this.details = detailsArg;
        this.grid = gridArg;
    }

    public long id() {
        return this.details.id();
    }

    public int revision() {
        return this.details.revision();
    }

    public String title() {
        return this.details.title();
    }

    public String author() {
        return this.details.author();
    }

    public String editor() {
        return this.details.editor();
    }

    public String copyright() {
        return this.details.copyright();
    }

    public String date() {
        return this.details.date();
    }

    public int columnCount() {
        return this.grid.columnCount();
    }

    public int rowCount() {
        return this.grid.rowCount();
    }

    public Set<GridCoord> shadedBoxes() {
        return this.grid.shaded();
    }

    public Map<GridCoord, Character> filledBoxes() {
        return this.grid.filled();
    }

    public static final class Builder {
        private final Set<GridCoord> shaded = new HashSet<GridCoord>();
        private final Map<GridCoord, Character> filled = new HashMap<GridCoord, Character>();
        private long id;
        private int revision;
        private String title = "";
        private String author = "";
        private String editor = "";
        private String copyright = "";
        private String date = "";
        private int numberOfColumns = 0;
        private int numberOfRows = 0;

        public Builder id(long value) {
            this.id = value;
            return this;
        }

        public Builder revision(int value) {
            this.revision = value;
            return this;
        }

        public Builder title(String value) {
            this.title = value;
            return this;
        }

        public Builder author(String value) {
            this.author = value;
            return this;
        }

        public Builder editor(String value) {
            this.editor = value;
            return this;
        }

        public Builder copyright(String value) {
            this.copyright = value;
            return this;
        }

        public Builder date(String value) {
            this.date = value;
            return this;
        }

        public Builder numberOfColumns(int value) {
            this.numberOfColumns = value;
            return this;
        }

        public Builder numberOfRows(int value) {
            this.numberOfRows = value;
            return this;
        }

        public Builder shaded(GridCoord position) {
            this.shaded.add(position);
            return this;
        }

        public Builder filled(GridCoord position, Character content) {
            this.filled.put(position, content);
            return this;
        }

        public SavedPuzzleViewModel build() {
            if (this.numberOfColumns <= 0) {
                throw new IllegalArgumentException("Number of columns shall be strictly positive");
            }
            if (this.numberOfRows <= 0) {
                throw new IllegalArgumentException("Number of rows shall be strictly positive");
            }
            PuzzleDetailsViewModel details = new PuzzleDetailsViewModel();
            details.id(this.id);
            details.revision(this.revision);
            details.title(this.title);
            details.author(this.author);
            details.editor(this.editor);
            details.copyright(this.copyright);
            details.date(this.date);
            SavedPuzzleGridViewModel grid = new SavedPuzzleGridViewModel(this.numberOfColumns, this.numberOfRows, this.shaded, this.filled);
            return new SavedPuzzleViewModel(details, grid);
        }
    }
}

