/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model.slot;

import java.util.List;
import java.util.stream.IntStream;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.slot.AcrossSlotOutline;
import re.belv.croiseur.gui.view.model.slot.DownSlotOutline;

public abstract sealed class SlotOutline
permits AcrossSlotOutline, DownSlotOutline {
    protected final int start;
    protected final int end;
    protected final int offset;

    protected SlotOutline(int startArg, int endArg, int offsetArg) {
        this.start = startArg;
        this.end = endArg;
        this.offset = offsetArg;
    }

    public static SlotOutline across(int columnStart, int columnEnd, int row) {
        return new AcrossSlotOutline(columnStart, columnEnd, row);
    }

    public static SlotOutline down(int rowStart, int rowEnd, int column) {
        return new DownSlotOutline(rowStart, rowEnd, column);
    }

    public final int length() {
        return this.end - this.start;
    }

    public final List<GridCoord> boxPositions() {
        return IntStream.range(this.start, this.end).mapToObj(varying -> this.coordOf(varying, this.offset)).toList();
    }

    public final boolean contains(GridCoord coord) {
        return this.offsetCoordinateOf(coord) == this.offset && this.varyingCoordinateOf(coord) >= this.start && this.varyingCoordinateOf(coord) < this.end;
    }

    abstract int varyingCoordinateOf(GridCoord var1);

    abstract int offsetCoordinateOf(GridCoord var1);

    abstract GridCoord coordOf(int var1, int var2);
}

