/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model.slot;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.value.ObservableIntegerValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import re.belv.croiseur.gui.view.model.CrosswordBoxViewModel;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.slot.AcrossSlotShadedBoxProcessor;
import re.belv.croiseur.gui.view.model.slot.AcrossSlotsLightenedBoxProcessor;
import re.belv.croiseur.gui.view.model.slot.ColumnCountChangeProcessor;
import re.belv.croiseur.gui.view.model.slot.DownSlotShadedBoxProcessor;
import re.belv.croiseur.gui.view.model.slot.DownSlotsLightenedBoxProcessor;
import re.belv.croiseur.gui.view.model.slot.RowCountChangeProcessor;
import re.belv.croiseur.gui.view.model.slot.SlotOutline;

public final class SlotsViewModel {
    private static final Predicate<SlotOutline> AT_LEAST_TWO_BOXES = s -> s.length() >= 2;
    private final ReadOnlyListWrapper<SlotOutline> acrossSlots;
    private final ObservableList<SlotOutline> longAcrossSlots;
    private final ReadOnlyListWrapper<SlotOutline> downSlots;
    private final ObservableList<SlotOutline> longDownSlots;
    private final AcrossSlotShadedBoxProcessor acrossSlotsShadedBoxProcessor;
    private final DownSlotShadedBoxProcessor downSlotsShadedBoxProcessor;
    private final AcrossSlotsLightenedBoxProcessor acrossSlotsLightenedBoxProcessor;
    private final DownSlotsLightenedBoxProcessor downSlotsLightenedBoxProcessor;

    public SlotsViewModel(ObservableMap<GridCoord, CrosswordBoxViewModel> boxes, ObservableIntegerValue columnCount, ObservableIntegerValue rowCount) {
        this.acrossSlots = new ReadOnlyListWrapper((Object)this, "acrossSlots", SlotsViewModel.initialAcrossSlots(boxes, columnCount.get(), rowCount.get()));
        this.longAcrossSlots = this.acrossSlots.getReadOnlyProperty().filtered(AT_LEAST_TWO_BOXES);
        this.downSlots = new ReadOnlyListWrapper((Object)this, "downSlots", SlotsViewModel.initialDownSlots(boxes, columnCount.get(), rowCount.get()));
        this.longDownSlots = this.downSlots.getReadOnlyProperty().filtered(AT_LEAST_TWO_BOXES);
        this.acrossSlotsShadedBoxProcessor = new AcrossSlotShadedBoxProcessor((List<SlotOutline>)this.acrossSlots);
        this.downSlotsShadedBoxProcessor = new DownSlotShadedBoxProcessor((List<SlotOutline>)this.downSlots);
        this.acrossSlotsLightenedBoxProcessor = new AcrossSlotsLightenedBoxProcessor((List<SlotOutline>)this.acrossSlots);
        this.downSlotsLightenedBoxProcessor = new DownSlotsLightenedBoxProcessor((List<SlotOutline>)this.downSlots);
        boxes.forEach((coord, box) -> box.shadedProperty().addListener(observable -> this.onBoxShadingChange((CrosswordBoxViewModel)box, (GridCoord)coord)));
        boxes.addListener(change -> {
            if (change.wasAdded()) {
                GridCoord coord = (GridCoord)change.getKey();
                CrosswordBoxViewModel box = (CrosswordBoxViewModel)change.getValueAdded();
                box.shadedProperty().addListener(observable -> this.onBoxShadingChange(box, coord));
            }
        });
        ColumnCountChangeProcessor columnCountChangeProcessor = new ColumnCountChangeProcessor((List<SlotOutline>)this.downSlots, (List<SlotOutline>)this.acrossSlots);
        columnCount.addListener((observable, oldCount, newCount) -> columnCountChangeProcessor.process(oldCount.intValue(), newCount.intValue(), rowCount.get()));
        RowCountChangeProcessor rowCountChangeProcessor = new RowCountChangeProcessor((List<SlotOutline>)this.downSlots, (List<SlotOutline>)this.acrossSlots);
        rowCount.addListener((observable, oldCount, newCount) -> rowCountChangeProcessor.process(oldCount.intValue(), newCount.intValue(), columnCount.get()));
    }

    public ReadOnlyListProperty<SlotOutline> acrossSlotsProperty() {
        return this.acrossSlots.getReadOnlyProperty();
    }

    public Optional<SlotOutline> acrossSlotContaining(GridCoord coord) {
        return this.acrossSlots.stream().takeWhile(s -> s.offset <= coord.row()).filter(s -> s.contains(coord)).findFirst();
    }

    public ObservableList<SlotOutline> longAcrossSlots() {
        return this.longAcrossSlots;
    }

    public OptionalInt indexOfLongAcrossSlotContaining(GridCoord coord) {
        ListIterator it = this.longAcrossSlots.listIterator();
        while (it.hasNext()) {
            SlotOutline slot = (SlotOutline)it.next();
            if (slot.contains(coord)) {
                return OptionalInt.of(it.previousIndex());
            }
            if (slot.offset <= coord.row() && (slot.offset != coord.row() || slot.end <= coord.column())) continue;
            break;
        }
        return OptionalInt.empty();
    }

    public ReadOnlyListProperty<SlotOutline> downSlotsProperty() {
        return this.downSlots.getReadOnlyProperty();
    }

    public Optional<SlotOutline> downSlotContaining(GridCoord coord) {
        return this.downSlots.stream().takeWhile(s -> s.offset <= coord.column()).filter(s -> s.contains(coord)).findFirst();
    }

    public ObservableList<SlotOutline> longDownSlots() {
        return this.longDownSlots;
    }

    public OptionalInt indexOfLongDownSlotContaining(GridCoord coord) {
        ListIterator it = this.longDownSlots.listIterator();
        while (it.hasNext()) {
            SlotOutline slot = (SlotOutline)it.next();
            if (slot.contains(coord)) {
                return OptionalInt.of(it.previousIndex());
            }
            if (slot.offset <= coord.column() && (slot.offset != coord.column() || slot.end <= coord.row())) continue;
            break;
        }
        return OptionalInt.empty();
    }

    private static ObservableList<SlotOutline> initialAcrossSlots(Map<GridCoord, CrosswordBoxViewModel> boxes, int columnCount, int rowCount) {
        LinkedList<SlotOutline> initialAcrossSlots = new LinkedList<SlotOutline>();
        for (int row = 0; row < rowCount; ++row) {
            int columnStart;
            for (int column = columnStart = 0; column < columnCount; ++column) {
                if (!boxes.get(GridCoord.at(column, row)).isShaded()) continue;
                if (column - columnStart > 0) {
                    initialAcrossSlots.add(SlotOutline.across(columnStart, column, row));
                }
                columnStart = column + 1;
            }
            if (columnCount - columnStart <= 0) continue;
            initialAcrossSlots.add(SlotOutline.across(columnStart, columnCount, row));
        }
        return FXCollections.observableList(initialAcrossSlots);
    }

    private static ObservableList<SlotOutline> initialDownSlots(Map<GridCoord, CrosswordBoxViewModel> boxes, int columnCount, int rowCount) {
        LinkedList<SlotOutline> initialDownSlots = new LinkedList<SlotOutline>();
        for (int column = 0; column < columnCount; ++column) {
            int rowStart;
            for (int row = rowStart = 0; row < rowCount; ++row) {
                if (!boxes.get(GridCoord.at(column, row)).isShaded()) continue;
                if (row - rowStart > 0) {
                    initialDownSlots.add(SlotOutline.down(rowStart, row, column));
                }
                rowStart = row + 1;
            }
            if (rowCount - rowStart <= 0) continue;
            initialDownSlots.add(SlotOutline.down(rowStart, rowCount, column));
        }
        return FXCollections.observableList(initialDownSlots);
    }

    private void onBoxShadingChange(CrosswordBoxViewModel box, GridCoord coord) {
        if (box.isShaded()) {
            this.acrossSlotsShadedBoxProcessor.process(coord);
            this.downSlotsShadedBoxProcessor.process(coord);
        } else {
            this.acrossSlotsLightenedBoxProcessor.process(coord);
            this.downSlotsLightenedBoxProcessor.process(coord);
        }
    }
}

