/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import re.belv.croiseur.gui.view.model.util.AggregateList;

final class AggregateListImpl<T>
extends AbstractList<T>
implements AggregateList<T> {
    private final List<List<T>> lists = new LinkedList<List<T>>();

    AggregateListImpl() {
    }

    AggregateListImpl(Collection<T> collection) {
        this();
        this.lists.add(new ArrayList<T>(collection));
    }

    @SafeVarargs
    AggregateListImpl(Collection<T> collection, Collection<T> ... others) {
        this(collection);
        for (Collection<T> other : others) {
            this.lists.add(new ArrayList<T>(other));
        }
    }

    @Override
    public T get(int index) {
        int endIndex = 0;
        for (List<T> list : this.lists) {
            int startIndex = endIndex;
            if (index >= (endIndex += list.size())) continue;
            return list.get(index - startIndex);
        }
        throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
    }

    @Override
    public int size() {
        int size = 0;
        for (List<T> list : this.lists) {
            size += list.size();
        }
        return size;
    }

    @Override
    public void aggregate(Collection<T> collection) {
        this.lists.add(new ArrayList<T>(collection));
    }

    @Override
    public void aggregate(int index, Collection<T> collection) {
        this.lists.add(index, new ArrayList<T>(collection));
    }

    @Override
    public void disaggregate(int index) {
        this.lists.remove(index);
    }

    @Override
    public List<T> aggregatedAt(int index) {
        return this.lists.get(index);
    }

    @Override
    public int elementIndex(int aggregateIndex) {
        if (aggregateIndex >= this.lists.size()) {
            throw new IndexOutOfBoundsException();
        }
        int size = 0;
        for (List<T> list : this.lists.subList(0, aggregateIndex)) {
            size += list.size();
        }
        return size;
    }

    @Override
    public int aggregateCount() {
        return this.lists.size();
    }
}

