/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model.util;

import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableListBase;
import re.belv.croiseur.gui.view.model.util.AggregateList;
import re.belv.croiseur.gui.view.model.util.ObservableAggregateList;

final class ObservableAggregateListImpl<T>
extends ObservableListBase<T>
implements ObservableAggregateList<T> {
    private final AggregateList<T> backingList;

    ObservableAggregateListImpl(AggregateList<T> backingListArg) {
        this.backingList = backingListArg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(Collection<T> collection) {
        this.beginChange();
        try {
            int from = this.backingList.size();
            int added = collection.size();
            this.backingList.aggregate(collection);
            if (added > 0) {
                this.nextAdd(from, from + added);
            }
        }
        finally {
            this.endChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(int aggregateIndex, Collection<T> collection) {
        this.beginChange();
        try {
            int from = this.backingList.elementIndex(aggregateIndex);
            int added = collection.size();
            this.backingList.aggregate(aggregateIndex, collection);
            if (added > 0) {
                this.nextAdd(from, from + added);
            }
        }
        finally {
            this.endChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disaggregate(int aggregateIndex) {
        this.beginChange();
        try {
            int where = this.backingList.elementIndex(aggregateIndex);
            List<T> removed = this.backingList.aggregatedAt(aggregateIndex);
            this.backingList.disaggregate(aggregateIndex);
            if (removed.size() > 0) {
                this.nextRemove(where, removed);
            }
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public List<T> aggregatedAt(int aggregateIndex) {
        return this.backingList.aggregatedAt(aggregateIndex);
    }

    @Override
    public int elementIndex(int aggregateIndex) {
        return this.backingList.elementIndex(aggregateIndex);
    }

    @Override
    public int aggregateCount() {
        return this.backingList.aggregateCount();
    }

    @Override
    public T get(int index) {
        return (T)this.backingList.get(index);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }
}

