/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;

public final class SortedByCopyList<E>
extends ModifiableObservableListBase<E>
implements ObservableList<E> {
    private List<E> sorted;

    public SortedByCopyList(ObservableList<E> backing, Comparator<E> comparator) {
        Objects.requireNonNull(backing);
        Objects.requireNonNull(comparator);
        this.sorted = new ArrayList();
        backing.addListener(change -> {
            this.beginChange();
            try {
                while (change.next()) {
                    this.nextRemove(0, this.sorted);
                    this.sorted = new ArrayList(change.getList());
                    this.sorted.sort(comparator);
                    this.nextAdd(0, this.sorted.size());
                }
            }
            finally {
                this.endChange();
            }
        });
    }

    public E get(int index) {
        return this.sorted.get(index);
    }

    public int size() {
        return this.sorted.size();
    }

    protected void doAdd(int index, E element) {
        this.sorted.add(index, element);
    }

    protected E doSet(int index, E element) {
        return this.sorted.set(index, element);
    }

    protected E doRemove(int index) {
        return this.sorted.remove(index);
    }
}

