/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.common.puzzle;

public record GridPosition(int x, int y) {
    public GridPosition {
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException("Invalid grid position");
        }
    }

    public static GridPosition at(int x, int y) {
        return new GridPosition(x, y);
    }

    public GridPosition plusHorizontalOffset(int offset) {
        return new GridPosition(Math.max(0, this.x + offset), this.y);
    }

    public GridPosition plusVerticalOffset(int offset) {
        return new GridPosition(this.x, Math.max(0, this.y + offset));
    }

    @Override
    public String toString() {
        return "GridPosition{x=" + this.x + ", y=" + this.y + "}";
    }
}

